/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.PatternSubtreeConfigurationWrapper;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPatternSubtreeConfiguration {
    private static String CONFIG_FILE = "target/test-classes/testPatternSubtreeConfig.xml";
    private static String PATTERN = "BusinessClient[@name='${sys:Id}']";
    private XMLConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.setFile(new File(CONFIG_FILE));
        this.conf.load();
    }

    @Test
    public void testMultiConfiguration() {
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(10000L);
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((AbstractHierarchicalFileConfiguration)this.conf, PATTERN);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        System.setProperty("Id", "1001");
        Assert.assertTrue((config.getInt("rowsPerPage") == 15 ? 1 : 0) != 0);
        System.setProperty("Id", "1002");
        Assert.assertTrue((config.getInt("rowsPerPage") == 25 ? 1 : 0) != 0);
        System.setProperty("Id", "1003");
        Assert.assertTrue((config.getInt("rowsPerPage") == 35 ? 1 : 0) != 0);
    }
}

