/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.beanutils.BeanCreationTestBean;
import org.apache.commons.configuration.beanutils.BeanCreationTestBeanWithListChild;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBeanHelper {
    private static final String TEST_STRING = "testString";
    private static final int TEST_INT = 42;
    private static final String TEST_FACTORY = "testFactory";
    private BeanFactory tempDefaultBeanFactory;

    @Before
    public void setUp() throws Exception {
        this.tempDefaultBeanFactory = BeanHelper.getDefaultBeanFactory();
        this.deregisterFactories();
    }

    @After
    public void tearDown() throws Exception {
        this.deregisterFactories();
        BeanHelper.setDefaultBeanFactory((BeanFactory)this.tempDefaultBeanFactory);
    }

    private void deregisterFactories() {
        for (String name : BeanHelper.registeredFactoryNames()) {
            BeanHelper.deregisterBeanFactory((String)name);
        }
        Assert.assertTrue((String)"Remaining registered bean factories", (boolean)BeanHelper.registeredFactoryNames().isEmpty());
    }

    @Test
    public void testRegisterBeanFactory() {
        Assert.assertTrue((String)"List of registered factories is not empty", (boolean)BeanHelper.registeredFactoryNames().isEmpty());
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        Assert.assertEquals((String)"Wrong number of registered factories", (long)1L, (long)BeanHelper.registeredFactoryNames().size());
        Assert.assertTrue((String)"Test factory is not contained", (boolean)BeanHelper.registeredFactoryNames().contains(TEST_FACTORY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterBeanFactoryNull() {
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterBeanFactoryNullName() {
        BeanHelper.registerBeanFactory(null, (BeanFactory)new TestBeanFactory());
    }

    @Test
    public void testDeregisterBeanFactory() {
        Assert.assertNull((String)"deregistering non existing factory", (Object)BeanHelper.deregisterBeanFactory((String)TEST_FACTORY));
        Assert.assertNull((String)"deregistering null factory", (Object)BeanHelper.deregisterBeanFactory(null));
        TestBeanFactory factory = new TestBeanFactory();
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)factory);
        Assert.assertSame((String)"Could not deregister factory", (Object)factory, (Object)BeanHelper.deregisterBeanFactory((String)TEST_FACTORY));
        Assert.assertTrue((String)"List of factories is not empty", (boolean)BeanHelper.registeredFactoryNames().isEmpty());
    }

    @Test
    public void testGetDefaultBeanFactory() {
        Assert.assertSame((String)"Incorrect default bean factory", (Object)DefaultBeanFactory.INSTANCE, (Object)this.tempDefaultBeanFactory);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetDefaultBeanFactoryNull() {
        BeanHelper.setDefaultBeanFactory(null);
    }

    @Test
    public void testInitBean() {
        BeanHelper.setDefaultBeanFactory((BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        TestBean bean = new TestBean();
        BeanHelper.initBean((Object)bean, (BeanDeclaration)data);
        this.checkBean(bean);
    }

    @Test
    public void testInitBeanWithNoData() {
        TestBeanDeclaration data = new TestBeanDeclaration();
        TestBean bean = new TestBean();
        BeanHelper.initBean((Object)bean, (BeanDeclaration)data);
        Assert.assertNull((String)"Wrong string property", (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)0L, (long)bean.getIntValue());
        Assert.assertNull((String)"Buddy was set", (Object)bean.getBuddy());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testInitBeanWithInvalidProperty() {
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.getBeanProperties().put("nonExistingProperty", Boolean.TRUE);
        BeanHelper.initBean((Object)new TestBean(), (BeanDeclaration)data);
    }

    @Test
    public void testCreateBean() {
        TestBeanFactory factory = new TestBeanFactory();
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)factory);
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(TestBean.class.getName());
        this.checkBean((TestBean)BeanHelper.createBean((BeanDeclaration)data, null));
        Assert.assertNull((String)"A parameter was passed", (Object)factory.parameter);
    }

    @Test
    public void testCreateBeanWithListChildBean() {
        TestBeanFactory factory = new TestBeanFactory();
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)factory);
        TestBeanDeclaration data = this.setUpBeanDeclarationWithListChild();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBeanWithListChild.class.getName());
        this.checkBean((BeanCreationTestBeanWithListChild)BeanHelper.createBean((BeanDeclaration)data, null));
        Assert.assertNull((String)"A parameter was passed", (Object)factory.parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBeanWithNullDeclaration() {
        BeanHelper.createBean(null);
    }

    @Test
    public void testCreateBeanWithDefaultClass() {
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((TestBean)BeanHelper.createBean((BeanDeclaration)data, TestBean.class));
    }

    @Test
    public void testCreateBeanWithFactoryDefaultClass() {
        TestBeanFactory factory = new TestBeanFactory();
        factory.supportsDefaultClass = true;
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)factory);
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((TestBean)BeanHelper.createBean((BeanDeclaration)data, null));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithNoClass() {
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        BeanHelper.createBean((BeanDeclaration)data, null);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithInvalidClass() {
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName("non.existing.ClassName");
        BeanHelper.createBean((BeanDeclaration)data, null);
    }

    @Test
    public void testCreateBeanWithDefaultFactory() {
        BeanHelper.setDefaultBeanFactory((BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanClassName(TestBean.class.getName());
        this.checkBean((TestBean)BeanHelper.createBean((BeanDeclaration)data, null));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithUnknownFactory() {
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(TestBean.class.getName());
        BeanHelper.createBean((BeanDeclaration)data, null);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithException() {
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(this.getClass().getName());
        BeanHelper.createBean((BeanDeclaration)data, null);
    }

    @Test
    public void testCreateBeanWithParameter() {
        Integer param = new Integer(42);
        TestBeanFactory factory = new TestBeanFactory();
        BeanHelper.registerBeanFactory((String)TEST_FACTORY, (BeanFactory)factory);
        TestBeanDeclaration data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(TestBean.class.getName());
        this.checkBean((TestBean)BeanHelper.createBean((BeanDeclaration)data, null, (Object)param));
        Assert.assertSame((String)"Wrong parameter", (Object)param, (Object)factory.parameter);
    }

    private TestBeanDeclaration setUpBeanDeclaration() {
        TestBeanDeclaration data = new TestBeanDeclaration();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", "42");
        data.setBeanProperties(properties);
        TestBeanDeclaration buddyData = new TestBeanDeclaration();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", "Another test string");
        properties2.put("intValue", new Integer(100));
        buddyData.setBeanProperties(properties2);
        buddyData.setBeanClassName(TestBean.class.getName());
        if (BeanHelper.getDefaultBeanFactory() == null) {
            buddyData.setBeanFactoryName(TEST_FACTORY);
        }
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("buddy", buddyData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    private TestBeanDeclaration setUpBeanDeclarationWithListChild() {
        TestBeanDeclaration data = new TestBeanDeclaration();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        ArrayList<TestBeanDeclaration> childData = new ArrayList<TestBeanDeclaration>();
        childData.add(this.createChildBean("child1"));
        childData.add(this.createChildBean("child2"));
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("children", childData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    private TestBeanDeclaration createChildBean(String name) {
        TestBeanDeclaration childBean = new TestBeanDeclaration();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", name + " Another test string");
        properties2.put("intValue", new Integer(100));
        childBean.setBeanProperties(properties2);
        childBean.setBeanClassName(BeanCreationTestBean.class.getName());
        if (BeanHelper.getDefaultBeanFactory() == null) {
            childBean.setBeanFactoryName(TEST_FACTORY);
        }
        return childBean;
    }

    private void checkBean(TestBean bean) {
        Assert.assertEquals((String)"Wrong string property", (Object)TEST_STRING, (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)bean.getIntValue());
        TestBean buddy = bean.getBuddy();
        Assert.assertNotNull((String)"Buddy was not set", (Object)buddy);
        Assert.assertEquals((String)"Wrong string property in buddy", (Object)"Another test string", (Object)buddy.getStringValue());
        Assert.assertEquals((String)"Wrong int property in buddy", (long)100L, (long)buddy.getIntValue());
    }

    private void checkBean(BeanCreationTestBeanWithListChild bean) {
        Assert.assertEquals((String)"Wrong string property", (Object)TEST_STRING, (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)bean.getIntValue());
        List<BeanCreationTestBean> children = bean.getChildren();
        Assert.assertNotNull((String)"Children were not set", children);
        Assert.assertEquals((String)"Wrong number of children created", (long)children.size(), (long)2L);
        Assert.assertNotNull((String)"First child was set as null", (Object)children.get(0));
        Assert.assertNotNull((String)"Second child was set as null", (Object)children.get(1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestBeanDeclaration
    implements BeanDeclaration {
        private String beanClassName;
        private String beanFactoryName;
        private Object beanFactoryParameter;
        private Map<String, Object> beanProperties;
        private Map<String, Object> nestedBeanDeclarations;

        TestBeanDeclaration() {
        }

        public String getBeanClassName() {
            return this.beanClassName;
        }

        public void setBeanClassName(String beanClassName) {
            this.beanClassName = beanClassName;
        }

        public String getBeanFactoryName() {
            return this.beanFactoryName;
        }

        public void setBeanFactoryName(String beanFactoryName) {
            this.beanFactoryName = beanFactoryName;
        }

        public Object getBeanFactoryParameter() {
            return this.beanFactoryParameter;
        }

        public void setBeanFactoryParameter(Object beanFactoryParameter) {
            this.beanFactoryParameter = beanFactoryParameter;
        }

        public Map<String, Object> getBeanProperties() {
            return this.beanProperties;
        }

        public void setBeanProperties(Map<String, Object> beanProperties) {
            this.beanProperties = beanProperties;
        }

        public Map<String, Object> getNestedBeanDeclarations() {
            return this.nestedBeanDeclarations;
        }

        public void setNestedBeanDeclarations(Map<String, Object> nestedBeanDeclarations) {
            this.nestedBeanDeclarations = nestedBeanDeclarations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestBeanFactory
    implements BeanFactory {
        Object parameter;
        boolean supportsDefaultClass;

        TestBeanFactory() {
        }

        public Object createBean(Class<?> beanClass, BeanDeclaration data, Object param) throws Exception {
            this.parameter = param;
            if (TestBean.class.equals(beanClass)) {
                TestBean bean = new TestBean();
                BeanHelper.initBean((Object)bean, (BeanDeclaration)data);
                return bean;
            }
            if (BeanCreationTestBeanWithListChild.class.equals(beanClass)) {
                BeanCreationTestBeanWithListChild bean = new BeanCreationTestBeanWithListChild();
                BeanHelper.initBean((Object)bean, (BeanDeclaration)data);
                return bean;
            }
            throw new IllegalArgumentException("Unsupported class: " + beanClass);
        }

        public Class<?> getDefaultBeanClass() {
            return this.supportsDefaultClass ? TestBean.class : null;
        }
    }

    public static class TestBean {
        private String stringValue;
        private int intValue;
        private TestBean buddy;

        public TestBean getBuddy() {
            return this.buddy;
        }

        public void setBuddy(TestBean buddy) {
            this.buddy = buddy;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }
    }
}

