/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.interpol;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationInterpolator {
    private static final String TEST_PREFIX = "prefix";
    private static final String TEST_NAME = "varname";
    private static final String TEST_VALUE = "TestVariableValue";
    private ConfigurationInterpolator interpolator;

    @Before
    public void setUp() throws Exception {
        this.interpolator = new ConfigurationInterpolator();
    }

    @After
    public void tearDown() throws Exception {
        ConfigurationInterpolator.deregisterGlobalLookup((String)TEST_PREFIX);
    }

    @Test
    public void testInit() {
        Assert.assertNull((String)"A default lookup is set", (Object)this.interpolator.getDefaultLookup());
        Assert.assertFalse((String)"No predefined lookups", (boolean)this.interpolator.prefixSet().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterGlobalLookupNullPrefix() {
        ConfigurationInterpolator.registerGlobalLookup(null, (StrLookup)StrLookup.noneLookup());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterGlobalLookupNull() {
        ConfigurationInterpolator.registerGlobalLookup((String)TEST_PREFIX, null);
    }

    @Test
    public void testRegisterGlobalLookup() {
        ConfigurationInterpolator.registerGlobalLookup((String)TEST_PREFIX, (StrLookup)StrLookup.noneLookup());
        ConfigurationInterpolator int2 = new ConfigurationInterpolator();
        Assert.assertTrue((String)"No lookup registered for test prefix", (boolean)int2.prefixSet().contains(TEST_PREFIX));
        Assert.assertFalse((String)"Existing instance was modified", (boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
    }

    @Test
    public void testDeregisterGlobalLookup() {
        ConfigurationInterpolator.registerGlobalLookup((String)TEST_PREFIX, (StrLookup)StrLookup.noneLookup());
        Assert.assertTrue((String)"Lookup could not be deregistered", (boolean)ConfigurationInterpolator.deregisterGlobalLookup((String)TEST_PREFIX));
        ConfigurationInterpolator int2 = new ConfigurationInterpolator();
        Assert.assertFalse((String)"Deregistered lookup still available", (boolean)int2.prefixSet().contains(TEST_PREFIX));
    }

    @Test
    public void testDeregisterGlobalLookupNonExisting() {
        Assert.assertFalse((String)"Could deregister unknown global lookup", (boolean)ConfigurationInterpolator.deregisterGlobalLookup((String)TEST_PREFIX));
    }

    @Test
    public void testRegisterLookup() {
        int cnt = this.interpolator.prefixSet().size();
        this.interpolator.registerLookup(TEST_PREFIX, StrLookup.noneLookup());
        Assert.assertTrue((String)"New lookup not registered", (boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
        Assert.assertEquals((String)"Wrong number of registered lookups", (long)(cnt + 1), (long)this.interpolator.prefixSet().size());
        ConfigurationInterpolator int2 = new ConfigurationInterpolator();
        Assert.assertFalse((String)"Local registration has global impact", (boolean)int2.prefixSet().contains(TEST_PREFIX));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterLookupNull() {
        this.interpolator.registerLookup(TEST_PREFIX, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterLookupNullPrefix() {
        this.interpolator.registerLookup(null, StrLookup.noneLookup());
    }

    @Test
    public void testDeregisterLookup() {
        this.interpolator.registerLookup(TEST_PREFIX, StrLookup.noneLookup());
        Assert.assertTrue((String)"Derigstration not successfull", (boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
        Assert.assertFalse((String)"Deregistered prefix still contained", (boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
    }

    @Test
    public void testDeregisterLookupNonExisting() {
        Assert.assertFalse((String)"Could deregister unknown lookup", (boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
    }

    @Test
    public void testLookupWithPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, this.setUpTestLookup());
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.lookup("prefix:varname"));
    }

    @Test
    public void testLookupWithUnknownPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, this.setUpTestLookup());
        Assert.assertNull((String)"Variable could be resolved", (Object)this.interpolator.lookup("UnknownPrefix:varname"));
        Assert.assertNull((String)"Variable with empty prefix could be resolved", (Object)this.interpolator.lookup(":varname"));
    }

    @Test
    public void testLookupDefault() {
        this.interpolator.setDefaultLookup(this.setUpTestLookup());
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.lookup(TEST_NAME));
    }

    @Test
    public void testLookupNoDefault() {
        Assert.assertNull((String)"Variable could be resolved", (Object)this.interpolator.lookup(TEST_NAME));
    }

    @Test
    public void testLookupEmptyPrefix() {
        this.interpolator.registerLookup("", this.setUpTestLookup());
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.lookup(":varname"));
    }

    @Test
    public void testLookupEmptyVarName() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", TEST_VALUE);
        this.interpolator.registerLookup(TEST_PREFIX, StrLookup.mapLookup(map));
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.lookup("prefix:"));
    }

    @Test
    public void testLookupDefaultEmptyVarName() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", TEST_VALUE);
        this.interpolator.setDefaultLookup(StrLookup.mapLookup(map));
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.lookup(""));
    }

    @Test
    public void testLookupNull() {
        Assert.assertNull((String)"Could resolve null variable", (Object)this.interpolator.lookup(null));
    }

    private StrLookup setUpTestLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TEST_NAME, TEST_VALUE);
        return StrLookup.mapLookup(map);
    }

    @Test
    public void testLookupSysProperties() {
        Properties sysProps = System.getProperties();
        for (Object prop : sysProps.keySet()) {
            String key = (String)prop;
            Assert.assertEquals((String)("Wrong value for system property " + key), (Object)sysProps.getProperty(key), (Object)this.interpolator.lookup("sys:" + key));
        }
    }

    @Test
    public void testLookupConstants() {
        String varName = ConfigurationInterpolator.class.getName() + ".PREFIX_CONSTANTS";
        Assert.assertEquals((String)"Wrong constant value", (Object)"const", (Object)this.interpolator.lookup("const:" + varName));
    }

    @Test
    public void testLookupDefaultAfterPrefixFails() {
        String varName = "prefix:varname2";
        this.interpolator.registerLookup(TEST_PREFIX, this.setUpTestLookup());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("prefix:varname2", TEST_VALUE);
        this.interpolator.setDefaultLookup(StrLookup.mapLookup(map));
        Assert.assertEquals((String)"Variable is not resolved by default lookup", (Object)TEST_VALUE, (Object)this.interpolator.lookup("prefix:varname2"));
    }
}

