/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junitx.framework.ArrayAssert;
import junitx.framework.ListAssert;
import junitx.framework.ObjectAssert;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.plist.XMLPropertyListConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestXMLPropertyListConfiguration {
    private FileConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new XMLPropertyListConfiguration();
        this.config.setFile(ConfigurationAssert.getTestFile("test.plist.xml"));
        this.config.load();
    }

    @Test
    public void testString() throws Exception {
        Assert.assertEquals((String)"'string' property", (Object)"value1", (Object)this.config.getString("string"));
    }

    @Test
    public void testInteger() throws Exception {
        Assert.assertEquals((String)"'integer' property", (long)12345678900L, (long)this.config.getLong("integer"));
    }

    @Test
    public void testReal() throws Exception {
        Assert.assertEquals((String)"'real' property", (double)-12.345, (double)this.config.getDouble("real"), (double)0.0);
    }

    @Test
    public void testBoolean() throws Exception {
        Assert.assertEquals((String)"'boolean1' property", (Object)true, (Object)this.config.getBoolean("boolean1"));
        Assert.assertEquals((String)"'boolean2' property", (Object)false, (Object)this.config.getBoolean("boolean2"));
    }

    @Test
    public void testDictionary() {
        Assert.assertEquals((String)"1st element", (Object)"value1", (Object)this.config.getProperty("dictionary.key1"));
        Assert.assertEquals((String)"2nd element", (Object)"value2", (Object)this.config.getProperty("dictionary.key2"));
        Assert.assertEquals((String)"3rd element", (Object)"value3", (Object)this.config.getProperty("dictionary.key3"));
    }

    @Test
    public void testDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(2005, 0, 1, 12, 0, 0);
        Assert.assertEquals((String)"'date' property", (Object)calendar.getTime(), (Object)this.config.getProperty("date"));
        calendar.setTimeZone(TimeZone.getTimeZone("CET"));
        calendar.set(2002, 2, 22, 11, 30, 0);
        Assert.assertEquals((String)"'date-gnustep' property", (Object)calendar.getTime(), (Object)this.config.getProperty("date-gnustep"));
    }

    @Test
    public void testSubset() {
        Configuration subset = this.config.subset("dictionary");
        Iterator keys = subset.getKeys();
        String key = (String)keys.next();
        Assert.assertEquals((String)"1st key", (Object)"key1", (Object)key);
        Assert.assertEquals((String)"1st value", (Object)"value1", (Object)subset.getString(key));
        key = (String)keys.next();
        Assert.assertEquals((String)"2nd key", (Object)"key2", (Object)key);
        Assert.assertEquals((String)"2nd value", (Object)"value2", (Object)subset.getString(key));
        key = (String)keys.next();
        Assert.assertEquals((String)"3rd key", (Object)"key3", (Object)key);
        Assert.assertEquals((String)"3rd value", (Object)"value3", (Object)subset.getString(key));
        Assert.assertFalse((String)"more than 3 properties founds", (boolean)keys.hasNext());
    }

    @Test
    public void testArray() {
        Object array = this.config.getProperty("array");
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList("array");
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)3L, (long)list.size());
        Assert.assertEquals((String)"1st element", (Object)"value1", list.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"value2", list.get(1));
        Assert.assertEquals((String)"3rd element", (Object)"value3", list.get(2));
    }

    @Test
    public void testNestedArray() {
        String key = "nested-array";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(0));
        List list1 = (List)list.get(0);
        Assert.assertFalse((String)"nested array 1 is empty", (boolean)list1.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list1.size());
        Assert.assertEquals((String)"1st element", (Object)"a", list1.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"b", list1.get(1));
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(1));
        List list2 = (List)list.get(1);
        Assert.assertFalse((String)"nested array 2 is empty", (boolean)list2.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"1st element", (Object)"c", list2.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"d", list2.get(1));
    }

    @Test
    public void testDictionaryArray() {
        String key = "dictionary-array";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(0));
        Configuration conf1 = (Configuration)list.get(0);
        Assert.assertFalse((String)"configuration 1 is empty", (boolean)conf1.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"bar", (Object)conf1.getProperty("foo"));
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(1));
        Configuration conf2 = (Configuration)list.get(1);
        Assert.assertFalse((String)"configuration 2 is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"value", (Object)conf2.getProperty("key"));
    }

    @Test
    public void testNested() {
        Assert.assertEquals((String)"nested property", (Object)"value", (Object)this.config.getString("nested.node1.node2.node3"));
    }

    @Test
    public void testSave() throws Exception {
        File savedFile = new File("target/testsave.plist.xml");
        if (savedFile.exists()) {
            Assert.assertTrue((boolean)savedFile.delete());
        }
        String filename = savedFile.getAbsolutePath();
        this.config.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration(new File(filename));
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("The saved configuration doesn't contain the key '" + key + "'"), (boolean)checkConfig.containsKey(key));
            Object value = checkConfig.getProperty(key);
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                ArrayAssert.assertEquals((String)("Value of the '" + key + "' property"), (byte[])((byte[])this.config.getProperty(key)), (byte[])array);
                continue;
            }
            if (value instanceof List) {
                List list1 = (List)this.config.getProperty(key);
                List list2 = (List)value;
                Assert.assertEquals((String)("The size of the list for the key '" + key + "' doesn't match"), (long)list1.size(), (long)list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    Object value1 = list1.get(i);
                    Object value2 = list2.get(i);
                    if (value1 instanceof Configuration) {
                        StrictConfigurationComparator comparator = new StrictConfigurationComparator();
                        Assert.assertTrue((String)("The dictionnary at index " + i + " for the key '" + key + "' doesn't match"), (boolean)comparator.compare((Configuration)value1, (Configuration)value2));
                        continue;
                    }
                    Assert.assertEquals((String)("Element at index " + i + " for the key '" + key + "'"), value1, value2);
                }
                ListAssert.assertEquals((String)("Value of the '" + key + "' property"), (List)((List)this.config.getProperty(key)), (List)list1);
                continue;
            }
            Assert.assertEquals((String)("Value of the '" + key + "' property"), (Object)this.config.getProperty(key), (Object)checkConfig.getProperty(key));
        }
    }

    @Test
    public void testSaveEmptyDictionary() throws Exception {
        File savedFile = new File("target/testsave.plist.xml");
        if (savedFile.exists()) {
            Assert.assertTrue((boolean)savedFile.delete());
        }
        String filename = savedFile.getAbsolutePath();
        this.config.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration(new File(filename));
        Assert.assertEquals(null, (Object)this.config.getProperty("empty-dictionary"));
        Assert.assertEquals(null, (Object)checkConfig.getProperty("empty-dictionary"));
    }

    @Test
    public void testSetDataProperty() throws Exception {
        byte[] expected = new byte[]{1, 2, 3, 4};
        XMLPropertyListConfiguration config = new XMLPropertyListConfiguration();
        config.setProperty("foo", (Object)expected);
        config.save("target/testdata.plist.xml");
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration("target/testdata.plist.xml");
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testAddDataProperty() throws Exception {
        byte[] expected = new byte[]{1, 2, 3, 4};
        XMLPropertyListConfiguration config = new XMLPropertyListConfiguration();
        config.addProperty("foo", (Object)expected);
        config.save("target/testdata.plist.xml");
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration("target/testdata.plist.xml");
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testInitCopy() {
        XMLPropertyListConfiguration copy = new XMLPropertyListConfiguration((HierarchicalConfiguration)this.config);
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assert.assertTrue((String)"Configurations are not equal", (boolean)comp.compare((Configuration)this.config, (Configuration)copy));
    }

    @Test
    public void testLoadNoDict() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration();
        plist.setFile(ConfigurationAssert.getTestFile("test2.plist.xml"));
        plist.load();
        Assert.assertFalse((String)"Configuration is empty", (boolean)plist.isEmpty());
    }

    @Test
    public void testLoadNoDictConstr() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration(ConfigurationAssert.getTestFile("test2.plist.xml"));
        Assert.assertFalse((String)"Configuration is empty", (boolean)plist.isEmpty());
    }

    @Test
    public void testSetDatePropertyInvalid() throws ConfigurationException {
        this.config.clear();
        this.config.setFile(ConfigurationAssert.getTestFile("test_invalid_date.plist.xml"));
        this.config.load();
        Assert.assertEquals((String)"'string' property", (Object)"value1", (Object)this.config.getString("string"));
        Assert.assertFalse((String)"Date property was loaded", (boolean)this.config.containsKey("date"));
    }
}

