/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import java.io.File;
import java.io.FileWriter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.VFSFileSystem;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.reloading.VFSFileChangedReloadingStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVFSFileChangedReloadingStrategy {
    private static final String TEST_FILE = "test.properties";

    @Before
    public void setUp() throws Exception {
        FileSystem.setDefaultFileSystem((FileSystem)new VFSFileSystem());
    }

    @After
    public void tearDown() throws Exception {
        FileSystem.resetDefaultFileSystem();
    }

    @Test
    public void testAutomaticReloading() throws Exception {
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        PropertiesConfiguration config = new PropertiesConfiguration("target/testReload.properties");
        VFSFileChangedReloadingStrategy strategy = new VFSFileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertEquals((String)"Initial value", (Object)"value1", (Object)config.getString("string"));
        Thread.sleep(2000L);
        out = new FileWriter(file);
        out.write("string=value2");
        out.flush();
        out.close();
        Assert.assertEquals((String)"Modified value with enabled reloading", (Object)"value2", (Object)config.getString("string"));
    }

    @Test
    public void testNewFileReloading() throws Exception {
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setFile(file);
        VFSFileChangedReloadingStrategy strategy = new VFSFileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertNull((String)"Initial value", (Object)config.getString("string"));
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Modified value with enabled reloading", (Object)"value1", (Object)config.getString("string"));
    }

    @Test
    public void testGetRefreshDelay() throws Exception {
        VFSFileChangedReloadingStrategy strategy = new VFSFileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        Assert.assertEquals((String)"refresh delay", (long)500L, (long)strategy.getRefreshDelay());
    }

    @Test
    public void testReloadingRequiredMultipleTimes() throws ConfigurationException {
        VFSFileChangedReloadingStrategy strategy = new VFSFileChangedReloadingStrategy(){

            protected boolean hasChanged() {
                return true;
            }
        };
        strategy.setRefreshDelay(100000L);
        PropertiesConfiguration config = new PropertiesConfiguration(TEST_FILE);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertTrue((String)"Reloading not required", (boolean)strategy.reloadingRequired());
        Assert.assertTrue((String)"Reloading no more required", (boolean)strategy.reloadingRequired());
        strategy.reloadingPerformed();
        Assert.assertFalse((String)"Reloading still required", (boolean)strategy.reloadingRequired());
    }
}

