/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultExpressionEngineSymbols {
    private static DefaultExpressionEngineSymbols.Builder builder() {
        return new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
    }

    private static void expEqual(Object o1, Object o2) {
        Assertions.assertEquals((Object)o1, (Object)o2);
        Assertions.assertEquals((Object)o2, (Object)o1);
        Assertions.assertEquals((int)o1.hashCode(), (int)o2.hashCode());
    }

    private static void expNE(Object o1, Object o2) {
        Assertions.assertNotEquals((Object)o1, (Object)o2);
        if (o2 != null) {
            Assertions.assertNotEquals((Object)o2, (Object)o1);
        }
    }

    @Test
    void testDefaultSymbols() {
        Assertions.assertEquals((Object)".", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getPropertyDelimiter());
        Assertions.assertEquals((Object)"..", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getEscapedDelimiter());
        Assertions.assertEquals((Object)"(", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getIndexStart());
        Assertions.assertEquals((Object)")", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getIndexEnd());
        Assertions.assertEquals((Object)"[@", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getAttributeStart());
        Assertions.assertEquals((Object)"]", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getAttributeEnd());
    }

    @Test
    void testEqualsFalse() {
        DefaultExpressionEngineSymbols s1 = DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS;
        DefaultExpressionEngineSymbols s2 = TestDefaultExpressionEngineSymbols.builder().setPropertyDelimiter("/").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setEscapedDelimiter("\\.").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setIndexStart("[").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setIndexEnd("]").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setAttributeStart("#").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
        s2 = TestDefaultExpressionEngineSymbols.builder().setAttributeEnd("~").create();
        TestDefaultExpressionEngineSymbols.expNE(s1, s2);
    }

    @Test
    void testEqualsNull() {
        TestDefaultExpressionEngineSymbols.expNE(TestDefaultExpressionEngineSymbols.builder().create(), null);
    }

    @Test
    void testEqualsOtherClass() {
        TestDefaultExpressionEngineSymbols.expNE(TestDefaultExpressionEngineSymbols.builder().create(), this);
    }

    @Test
    void testEqualsTrue() {
        TestDefaultExpressionEngineSymbols.expEqual(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        DefaultExpressionEngineSymbols s2 = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).create();
        TestDefaultExpressionEngineSymbols.expEqual(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, s2);
    }

    @Test
    void testToString() {
        DefaultExpressionEngineSymbols symbols = TestDefaultExpressionEngineSymbols.builder().create();
        String s = symbols.toString();
        Assertions.assertTrue((boolean)s.contains("propertyDelimiter=" + symbols.getPropertyDelimiter()));
        Assertions.assertTrue((boolean)s.contains("escapedDelimiter=" + symbols.getEscapedDelimiter()));
        Assertions.assertTrue((boolean)s.contains("indexStart=" + symbols.getIndexStart()));
        Assertions.assertTrue((boolean)s.contains("indexEnd=" + symbols.getIndexEnd()));
        Assertions.assertTrue((boolean)s.contains("attributeStart=" + symbols.getAttributeStart()));
        Assertions.assertTrue((boolean)s.contains("attributeEnd=" + symbols.getAttributeEnd()));
    }
}

