/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.euclidean.twod.BoundaryList2D;
import org.apache.commons.geometry.euclidean.twod.BoundarySourceBoundsBuilder2D;
import org.apache.commons.geometry.euclidean.twod.BoundarySourceLinecaster2D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LinecastPoint2D;
import org.apache.commons.geometry.euclidean.twod.Linecastable2D;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;

public interface BoundarySource2D
extends BoundarySource<LineConvexSubset>,
Linecastable2D {
    default public BoundaryList2D toList() {
        List boundaries = this.boundaryStream().collect(Collectors.toList());
        return new BoundaryList2D(boundaries);
    }

    default public RegionBSPTree2D toTree() {
        RegionBSPTree2D tree = RegionBSPTree2D.empty();
        tree.insert(this);
        return tree;
    }

    @Override
    default public List<LinecastPoint2D> linecast(LineConvexSubset subset) {
        return new BoundarySourceLinecaster2D(this).linecast(subset);
    }

    @Override
    default public LinecastPoint2D linecastFirst(LineConvexSubset subset) {
        return new BoundarySourceLinecaster2D(this).linecastFirst(subset);
    }

    default public Bounds2D getBounds() {
        return new BoundarySourceBoundsBuilder2D().getBounds(this);
    }

    public static BoundarySource2D of(LineConvexSubset ... boundaries) {
        return BoundarySource2D.of(Arrays.asList(boundaries));
    }

    public static BoundarySource2D of(Collection<LineConvexSubset> boundaries) {
        return boundaries::stream;
    }
}

