/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed;

import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.input.FileGeometryInput;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.input.UrlGeometryInput;
import org.apache.commons.geometry.io.core.output.FileGeometryOutput;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.geometry.io.euclidean.threed.BoundaryIOManager3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.numbers.core.Precision;

public final class IO3D {
    private IO3D() {
    }

    public static FacetDefinitionReader facetDefinitionReader(Path path) {
        return IO3D.facetDefinitionReader((GeometryInput)new FileGeometryInput(path), null);
    }

    public static FacetDefinitionReader facetDefinitionReader(URL url) {
        return IO3D.facetDefinitionReader((GeometryInput)new UrlGeometryInput(url), null);
    }

    public static FacetDefinitionReader facetDefinitionReader(GeometryInput in, GeometryFormat fmt) {
        return IO3D.getDefaultManager().facetDefinitionReader(in, fmt);
    }

    public static Stream<FacetDefinition> facets(Path path) {
        return IO3D.facets((GeometryInput)new FileGeometryInput(path), null);
    }

    public static Stream<FacetDefinition> facets(URL url) {
        return IO3D.facets((GeometryInput)new UrlGeometryInput(url), null);
    }

    public static Stream<FacetDefinition> facets(GeometryInput in, GeometryFormat fmt) {
        return IO3D.getDefaultManager().facets(in, fmt);
    }

    public static Stream<PlaneConvexSubset> boundaries(Path path, Precision.DoubleEquivalence precision) {
        return IO3D.boundaries((GeometryInput)new FileGeometryInput(path), null, precision);
    }

    public static Stream<PlaneConvexSubset> boundaries(URL url, Precision.DoubleEquivalence precision) {
        return IO3D.boundaries((GeometryInput)new UrlGeometryInput(url), null, precision);
    }

    public static Stream<PlaneConvexSubset> boundaries(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return IO3D.getDefaultManager().boundaries(in, fmt, precision);
    }

    public static Stream<Triangle3D> triangles(Path path, Precision.DoubleEquivalence precision) {
        return IO3D.triangles((GeometryInput)new FileGeometryInput(path), null, precision);
    }

    public static Stream<Triangle3D> triangles(URL url, Precision.DoubleEquivalence precision) {
        return IO3D.triangles((GeometryInput)new UrlGeometryInput(url), null, precision);
    }

    public static Stream<Triangle3D> triangles(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return IO3D.getDefaultManager().triangles(in, fmt, precision);
    }

    public static BoundarySource3D read(Path path, Precision.DoubleEquivalence precision) {
        return IO3D.read((GeometryInput)new FileGeometryInput(path), null, precision);
    }

    public static BoundarySource3D read(URL url, Precision.DoubleEquivalence precision) {
        return IO3D.read((GeometryInput)new UrlGeometryInput(url), null, precision);
    }

    public static BoundarySource3D read(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return (BoundarySource3D)IO3D.getDefaultManager().read(in, fmt, precision);
    }

    public static TriangleMesh readTriangleMesh(Path path, Precision.DoubleEquivalence precision) {
        return IO3D.readTriangleMesh((GeometryInput)new FileGeometryInput(path), null, precision);
    }

    public static TriangleMesh readTriangleMesh(URL url, Precision.DoubleEquivalence precision) {
        return IO3D.readTriangleMesh((GeometryInput)new UrlGeometryInput(url), null, precision);
    }

    public static TriangleMesh readTriangleMesh(GeometryInput in, GeometryFormat fmt, Precision.DoubleEquivalence precision) {
        return IO3D.getDefaultManager().readTriangleMesh(in, fmt, precision);
    }

    public static void write(Stream<? extends PlaneConvexSubset> boundaries, Path path) {
        IO3D.write(boundaries, (GeometryOutput)new FileGeometryOutput(path), null);
    }

    public static void write(Stream<? extends PlaneConvexSubset> boundaries, GeometryOutput out, GeometryFormat fmt) {
        IO3D.getDefaultManager().write(boundaries, out, fmt);
    }

    public static void write(BoundarySource3D src, Path path) {
        IO3D.write(src, (GeometryOutput)new FileGeometryOutput(path), null);
    }

    public static void write(BoundarySource3D src, GeometryOutput out, GeometryFormat fmt) {
        IO3D.getDefaultManager().write((BoundarySource)src, out, fmt);
    }

    public static void writeFacets(Collection<? extends FacetDefinition> facets, Path path) {
        IO3D.writeFacets(facets, (GeometryOutput)new FileGeometryOutput(path), null);
    }

    public static void writeFacets(Collection<? extends FacetDefinition> facets, GeometryOutput out, GeometryFormat fmt) {
        IO3D.getDefaultManager().writeFacets(facets, out, fmt);
    }

    public static void writeFacets(Stream<? extends FacetDefinition> facets, Path path) {
        IO3D.writeFacets(facets, (GeometryOutput)new FileGeometryOutput(path), null);
    }

    public static void writeFacets(Stream<? extends FacetDefinition> facets, GeometryOutput out, GeometryFormat fmt) {
        IO3D.getDefaultManager().writeFacets(facets, out, fmt);
    }

    public static BoundaryIOManager3D getDefaultManager() {
        return ManagerHolder.DEFAULT_MANAGER;
    }

    private static final class ManagerHolder {
        private static final BoundaryIOManager3D DEFAULT_MANAGER = new BoundaryIOManager3D();

        private ManagerHolder() {
        }

        static {
            DEFAULT_MANAGER.registerDefaultHandlers();
        }
    }
}

