/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.TestUtils;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.test.ThrowOnCloseReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOConsumerTest {
    IOConsumerTest() {
    }

    @Test
    void testAccept() throws IOException {
        IOConsumer.noop().accept(null);
        IOConsumer.noop().accept((Object)".");
        Uncheck.accept(Files::size, (Object)PathUtils.current());
        AtomicReference ref = new AtomicReference();
        IOConsumer consumer = s -> ref.set(s + "1");
        consumer.accept((Object)"A");
        Assertions.assertEquals((Object)"A1", ref.get());
    }

    @Test
    void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOConsumer consumer1 = s -> ref.set(s + "1");
        IOConsumer consumer2 = s -> ref.set((String)ref.get() + "2" + s);
        consumer1.andThen(consumer2).accept((Object)"B");
        Assertions.assertEquals((Object)"B12B", ref.get());
    }

    @Test
    void testAsConsumer() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Optional.of("a").ifPresent(TestUtils.throwingIOConsumer().asConsumer()));
        AtomicReference ref = new AtomicReference();
        IOConsumer consumer1 = s -> ref.set(s + "1");
        Optional.of("a").ifPresent(consumer1.asConsumer());
        Assertions.assertEquals((Object)"a1", ref.get());
    }

    @Test
    void testForAllArrayOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Object[])null);
        IOConsumer.forAll(null, (Object[])null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Object[])new String[]{"1"}));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, (Object[])new String[]{"1"});
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    void testForAllArrayOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Object[])null);
        IOConsumer.forAll(null, (Object[])null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Object[])new String[]{"1", "2"}));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, (Object[])new String[]{"1", "2"});
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    void testForAllIterableOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Iterable)null);
        IOConsumer.forAll(null, (Iterable)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1")));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, Arrays.asList("1"));
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    void testForAllIterableOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Iterable)null);
        IOConsumer.forAll(null, (Iterable)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1", "2")));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, Arrays.asList("1", "2"));
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    void testForAllStreamOf1() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Stream)null);
        IOConsumer.forAll(null, (Stream)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1").stream()));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, Arrays.asList("1").stream());
        Assertions.assertEquals((Object)"01", (Object)ref.get());
    }

    @Test
    void testForAllStreamOf2() throws IOException {
        IOConsumer.forAll(TestUtils.throwingIOConsumer(), (Stream)null);
        IOConsumer.forAll(null, (Stream)null);
        Assertions.assertThrows(IOExceptionList.class, () -> IOConsumer.forAll(TestUtils.throwingIOConsumer(), Arrays.asList("1", "2").stream()));
        AtomicReference<String> ref = new AtomicReference<String>("0");
        IOConsumer consumer1 = s -> ref.set((String)ref.get() + s);
        IOConsumer.forAll((IOConsumer)consumer1, Arrays.asList("1", "2").stream());
        Assertions.assertEquals((Object)"012", (Object)ref.get());
    }

    @Test
    void testNoop() {
        Closeable nullCloseable = null;
        IOConsumer noopConsumer = IOConsumer.noop();
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)nullCloseable, (IOConsumer)noopConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), (IOConsumer)noopConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s"))), (IOConsumer)noopConsumer));
    }
}

