/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.pathable;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Artifacts;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.junit.Assert;

public class ParentFirstTestCase
extends TestCase {
    public static Test suite() throws Exception {
        Class<ParentFirstTestCase> thisClass = ParentFirstTestCase.class;
        ClassLoader thisClassLoader = thisClass.getClassLoader();
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.useExplicitLoader("junit.", thisClassLoader);
        parent.useExplicitLoader("org.junit.", thisClassLoader);
        parent.addLogicalLib("commons-logging");
        PathableClassLoader child = new PathableClassLoader(parent);
        child.addLogicalLib("testclasses");
        child.addLogicalLib("commons-logging-adapters");
        PathableClassLoader context = new PathableClassLoader(child);
        Class<?> testClass = child.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, context);
    }

    private static URL[] toURLArray(Enumeration<URL> e) {
        ArrayList<URL> l = new ArrayList<URL>();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        URL[] tmp = new URL[l.size()];
        return l.toArray(tmp);
    }

    private Set<ClassLoader> getAncestorCLs() {
        HashSet<ClassLoader> s = new HashSet<ClassLoader>();
        for (ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
            s.add(cl);
        }
        return s;
    }

    public void testPaths() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ParentFirstTestCase.assertNotNull((String)"Context class loader is null", (Object)contextLoader);
        ParentFirstTestCase.assertEquals((String)"Context class loader has unexpected type", (String)PathableClassLoader.class.getName(), (String)contextLoader.getClass().getName());
        ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ParentFirstTestCase.assertNotNull((String)"thisLoader is null", (Object)thisLoader);
        ParentFirstTestCase.assertEquals((String)"thisLoader has unexpected type", (String)PathableClassLoader.class.getName(), (String)thisLoader.getClass().getName());
        ParentFirstTestCase.assertSame((String)"Context class loader is not child of thisLoader", (Object)thisLoader, (Object)contextLoader.getParent());
        ClassLoader parentLoader = thisLoader.getParent();
        ParentFirstTestCase.assertNotNull((String)"Parent class loader is null", (Object)parentLoader);
        ParentFirstTestCase.assertEquals((String)"Parent class loader has unexpected type", (String)PathableClassLoader.class.getName(), (String)parentLoader.getClass().getName());
        ParentFirstTestCase.assertNull((String)"Parent class loader has non-null parent", (Object)parentLoader.getParent());
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        ParentFirstTestCase.assertNotNull((String)"System class loader is null", (Object)systemLoader);
        Assert.assertNotEquals((String)"System class loader has unexpected type", (Object)PathableClassLoader.class.getName(), (Object)systemLoader.getClass().getName());
        Class<?> junitTest = contextLoader.loadClass("junit.framework.Test");
        Set<ClassLoader> ancestorCLs = this.getAncestorCLs();
        ParentFirstTestCase.assertFalse((String)"Junit not loaded by ancestor class loader", (boolean)ancestorCLs.contains(junitTest.getClassLoader()));
        Class<?> logClass = contextLoader.loadClass("org.apache.commons.logging.Log");
        ParentFirstTestCase.assertSame((String)"Log class not loaded via parent", (Object)logClass.getClassLoader(), (Object)parentLoader);
        Class<?> log4jClass = contextLoader.loadClass("org.apache.commons.logging.impl.Log4JLogger");
        ParentFirstTestCase.assertSame((String)"Log4JLogger not loaded via parent", (Object)log4jClass.getClassLoader(), (Object)parentLoader);
        Class<?> testClass = contextLoader.loadClass("org.apache.commons.logging.PathableTestSuite");
        ParentFirstTestCase.assertSame((String)"PathableTestSuite not loaded via child", (Object)testClass.getClassLoader(), (Object)thisLoader);
        try {
            Class<?> noSuchClass = contextLoader.loadClass("no.such.class");
            ParentFirstTestCase.fail((String)"Class no.such.class is unexpectedly available");
            ParentFirstTestCase.assertNotNull(noSuchClass);
        }
        catch (ClassNotFoundException noSuchClass) {
            // empty catch block
        }
        Class<?> stringClass = contextLoader.loadClass("java.lang.String");
        ParentFirstTestCase.assertNull((String)"String class class loader is not null!", (Object)stringClass.getClassLoader());
    }

    public void testResource() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        URL resource = childLoader.getResource("nosuchfile");
        ParentFirstTestCase.assertNull((String)"Non-null URL returned for invalid resource name", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/Log.class");
        ParentFirstTestCase.assertNotNull((String)"Unable to locate Log.class resource", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/PathableTestSuite.class");
        ParentFirstTestCase.assertNotNull((String)"Unable to locate PathableTestSuite.class resource", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/impl/Log4JLogger.class");
        ParentFirstTestCase.assertNotNull((String)"Unable to locate Log4JLogger.class resource", (Object)resource);
        ParentFirstTestCase.assertTrue((String)"Incorrect source for Log4JLogger class", (resource.toString().indexOf(Artifacts.getMainJarName()) > 0 ? 1 : 0) != 0);
    }

    public void testResourceAsStream() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        ClassLoader parentLoader = childLoader.getParent();
        ClassLoader bootLoader = parentLoader.getParent();
        ParentFirstTestCase.assertNull((String)"Unexpected class loader hierarchy", (Object)bootLoader);
        InputStream is = childLoader.getResourceAsStream("nosuchfile");
        ParentFirstTestCase.assertNull((String)"Invalid resource returned non-null stream", (Object)is);
        is = childLoader.getResourceAsStream("org/apache/commons/logging/Log.class");
        ParentFirstTestCase.assertNotNull((String)"Null returned for valid resource", (Object)is);
        is.close();
    }

    public void testResources() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        ClassLoader parentLoader = childLoader.getParent();
        ClassLoader bootLoader = parentLoader.getParent();
        ParentFirstTestCase.assertNull((String)"Unexpected class loader hierarchy", (Object)bootLoader);
        Enumeration<URL> resources = childLoader.getResources("nosuchfile");
        URL[] urls = ParentFirstTestCase.toURLArray(resources);
        ParentFirstTestCase.assertEquals((String)"Non-null URL returned for invalid resource name", (int)0, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/Log.class");
        urls = ParentFirstTestCase.toURLArray(resources);
        ParentFirstTestCase.assertEquals((String)"Unexpected number of Log.class resources found", (int)1, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/PathableTestSuite.class");
        urls = ParentFirstTestCase.toURLArray(resources);
        ParentFirstTestCase.assertEquals((String)"Unexpected number of PathableTestSuite.class resources found", (int)1, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/impl/Log4JLogger.class");
        urls = ParentFirstTestCase.toURLArray(resources);
        ParentFirstTestCase.assertEquals((String)"Unexpected number of Log4JLogger.class resources found", (int)2, (int)urls.length);
        Object[] urlsToStrings = new String[]{urls[0].toString(), urls[1].toString()};
        Arrays.sort(urlsToStrings);
        ParentFirstTestCase.assertTrue((String)"Incorrect source for Log4JLogger class", (((String)urlsToStrings[0]).indexOf(Artifacts.getAdaptersJarName()) > 0 ? 1 : 0) != 0);
        ParentFirstTestCase.assertTrue((String)"Incorrect source for Log4JLogger class", (((String)urlsToStrings[1]).indexOf(Artifacts.getMainJarName()) > 0 ? 1 : 0) != 0);
    }
}

