/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecompositionTest;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.junit.Assert;
import org.junit.Test;

public class SingularValueDecompositionTest {
    private double[][] testSquare = new double[][]{{0.96, 1.72}, {2.28, 0.96}};
    private double[][] testNonSquare = new double[][]{{-0.864, 1.5408, -0.3456}, {-2.768, -1.1904, 1.6128}, {-1.152, 2.0544, -0.4608}, {-0.576, 0.3072, 2.8096}};
    private static final double normTolerance = 1.0E-13;

    @Test
    public void testMoreRows() {
        double[] singularValues = new double[]{123.456, 2.3, 1.001, 0.999};
        int rows = singularValues.length + 2;
        int columns = singularValues.length;
        Random r = new Random(15338437322523L);
        SingularValueDecomposition svd = new SingularValueDecomposition(this.createTestMatrix(r, rows, columns, singularValues));
        double[] computedSV = svd.getSingularValues();
        Assert.assertEquals((long)singularValues.length, (long)computedSV.length);
        for (int i = 0; i < singularValues.length; ++i) {
            Assert.assertEquals((double)singularValues[i], (double)computedSV[i], (double)1.0E-10);
        }
    }

    @Test
    public void testMoreColumns() {
        double[] singularValues = new double[]{123.456, 2.3, 1.001, 0.999};
        int rows = singularValues.length;
        int columns = singularValues.length + 2;
        Random r = new Random(732763225836210L);
        SingularValueDecomposition svd = new SingularValueDecomposition(this.createTestMatrix(r, rows, columns, singularValues));
        double[] computedSV = svd.getSingularValues();
        Assert.assertEquals((long)singularValues.length, (long)computedSV.length);
        for (int i = 0; i < singularValues.length; ++i) {
            Assert.assertEquals((double)singularValues[i], (double)computedSV[i], (double)1.0E-10);
        }
    }

    @Test
    public void testDimensions() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testSquare);
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        SingularValueDecomposition svd = new SingularValueDecomposition(matrix);
        Assert.assertEquals((long)m, (long)svd.getU().getRowDimension());
        Assert.assertEquals((long)m, (long)svd.getU().getColumnDimension());
        Assert.assertEquals((long)m, (long)svd.getS().getColumnDimension());
        Assert.assertEquals((long)n, (long)svd.getS().getColumnDimension());
        Assert.assertEquals((long)n, (long)svd.getV().getRowDimension());
        Assert.assertEquals((long)n, (long)svd.getV().getColumnDimension());
    }

    @Test
    public void testHadamard() {
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix((double[][])new double[][]{{7.5, 2.5, 4.5, 1.5}, {2.5, 7.5, 1.5, 4.5}, {4.5, 1.5, 7.5, 2.5}, {1.5, 4.5, 2.5, 7.5}}, false);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)matrix);
        Assert.assertEquals((double)16.0, (double)svd.getSingularValues()[0], (double)1.0E-14);
        Assert.assertEquals((double)8.0, (double)svd.getSingularValues()[1], (double)1.0E-14);
        Assert.assertEquals((double)4.0, (double)svd.getSingularValues()[2], (double)1.0E-14);
        Assert.assertEquals((double)2.0, (double)svd.getSingularValues()[3], (double)1.0E-14);
        Array2DRowRealMatrix fullCovariance = new Array2DRowRealMatrix((double[][])new double[][]{{0.0830078125, -0.0498046875, -0.0732421875, 0.0439453125}, {-0.0498046875, 0.0830078125, 0.0439453125, -0.0732421875}, {-0.0732421875, 0.0439453125, 0.0830078125, -0.0498046875}, {0.0439453125, -0.0732421875, -0.0498046875, 0.0830078125}}, false);
        Assert.assertEquals((double)0.0, (double)fullCovariance.subtract(svd.getCovariance(0.0)).getNorm(), (double)1.0E-14);
        Array2DRowRealMatrix halfCovariance = new Array2DRowRealMatrix((double[][])new double[][]{{0.0048828125, -0.0029296875, 0.0048828125, -0.0029296875}, {-0.0029296875, 0.0048828125, -0.0029296875, 0.0048828125}, {0.0048828125, -0.0029296875, 0.0048828125, -0.0029296875}, {-0.0029296875, 0.0048828125, -0.0029296875, 0.0048828125}}, false);
        Assert.assertEquals((double)0.0, (double)halfCovariance.subtract(svd.getCovariance(6.0)).getNorm(), (double)1.0E-14);
    }

    @Test
    public void testAEqualUSVt() {
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testNonSquare));
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose());
    }

    public void checkAEqualUSVt(RealMatrix matrix) {
        SingularValueDecomposition svd = new SingularValueDecomposition(matrix);
        RealMatrix u = svd.getU();
        RealMatrix s = svd.getS();
        RealMatrix v = svd.getV();
        double norm = u.multiply(s).multiply(v.transpose()).subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testUOrthogonal() {
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getU());
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).getU());
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).getU());
    }

    @Test
    public void testVOrthogonal() {
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getV());
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).getV());
        this.checkOrthogonal(new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).getV());
    }

    public void checkOrthogonal(RealMatrix m) {
        RealMatrix mTm = m.transpose().multiply(m);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)mTm.getRowDimension());
        Assert.assertEquals((double)0.0, (double)mTm.subtract(id).getNorm(), (double)1.0E-13);
    }

    public void testMatricesValues1() {
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.6, -0.8}, {0.8, 0.6}});
        RealMatrix sRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 0.0}, {0.0, 1.0}});
        RealMatrix vRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.8, 0.6}, {0.6, -0.8}});
        RealMatrix u = svd.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-13);
        RealMatrix s = svd.getS();
        Assert.assertEquals((double)0.0, (double)s.subtract(sRef).getNorm(), (double)1.0E-13);
        RealMatrix v = svd.getV();
        Assert.assertEquals((double)0.0, (double)v.subtract(vRef).getNorm(), (double)1.0E-13);
        Assert.assertTrue((u == svd.getU() ? 1 : 0) != 0);
        Assert.assertTrue((s == svd.getS() ? 1 : 0) != 0);
        Assert.assertTrue((v == svd.getV() ? 1 : 0) != 0);
    }

    public void useless_testMatricesValues2() {
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 0.6, 0.0}, {-0.8, 0.0, -0.6}, {0.0, 0.8, 0.0}, {-0.6, 0.0, 0.8}});
        RealMatrix sRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{4.0, 0.0, 0.0}, {0.0, 3.0, 0.0}, {0.0, 0.0, 2.0}});
        RealMatrix vRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.64, -0.48, 0.6}, {0.192, 0.856, 0.48}, {-0.744, -0.192, 0.64}});
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testNonSquare));
        RealMatrix u = svd.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-13);
        RealMatrix s = svd.getS();
        Assert.assertEquals((double)0.0, (double)s.subtract(sRef).getNorm(), (double)1.0E-13);
        RealMatrix v = svd.getV();
        Assert.assertEquals((double)0.0, (double)v.subtract(vRef).getNorm(), (double)1.0E-13);
        Assert.assertTrue((u == svd.getU() ? 1 : 0) != 0);
        Assert.assertTrue((s == svd.getS() ? 1 : 0) != 0);
        Assert.assertTrue((v == svd.getV() ? 1 : 0) != 0);
    }

    @Test
    public void testRank() {
        double[][] d = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 3.0}};
        Array2DRowRealMatrix m = new Array2DRowRealMatrix((double[][])d);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)m);
        Assert.assertEquals((long)2L, (long)svd.getRank());
    }

    @Test
    public void testStability1() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(201, 201);
        this.loadRealMatrix((RealMatrix)m, "matrix1.csv");
        try {
            new SingularValueDecomposition((RealMatrix)m);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception whilst constructing SVD");
        }
    }

    @Test
    public void testStability2() {
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(7, 168);
        this.loadRealMatrix((RealMatrix)m, "matrix2.csv");
        try {
            new SingularValueDecomposition((RealMatrix)m);
        }
        catch (Throwable e) {
            Assert.fail((String)"Exception whilst constructing SVD");
        }
    }

    private void loadRealMatrix(RealMatrix m, String resourceName) {
        try {
            String strLine;
            DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(resourceName));
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int row = 0;
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#")) continue;
                int col = 0;
                for (String entry : strLine.split(",")) {
                    m.setEntry(row, col++, Double.parseDouble(entry));
                }
                ++row;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testConditionNumber() {
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        Assert.assertEquals((double)3.0, (double)svd.getConditionNumber(), (double)1.5E-15);
    }

    @Test
    public void testInverseConditionNumber() {
        SingularValueDecomposition svd = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        Assert.assertEquals((double)0.3333333333333333, (double)svd.getInverseConditionNumber(), (double)1.5E-15);
    }

    private RealMatrix createTestMatrix(Random r, int rows, int columns, double[] singularValues) {
        RealMatrix u = EigenDecompositionTest.createOrthogonalMatrix(r, rows);
        Array2DRowRealMatrix d = new Array2DRowRealMatrix(rows, columns);
        d.setSubMatrix(MatrixUtils.createRealDiagonalMatrix((double[])singularValues).getData(), 0, 0);
        RealMatrix v = EigenDecompositionTest.createOrthogonalMatrix(r, columns);
        return u.multiply((RealMatrix)d).multiply(v);
    }

    @Test
    public void testIssue947() {
        double[][] nans = new double[][]{{Double.NaN, Double.NaN}, {Double.NaN, Double.NaN}};
        Array2DRowRealMatrix m = new Array2DRowRealMatrix((double[][])nans, false);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)m);
        Assert.assertTrue((boolean)Double.isNaN(svd.getSingularValues()[0]));
        Assert.assertTrue((boolean)Double.isNaN(svd.getSingularValues()[1]));
    }
}

