/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.fitting;

import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.fitting.CurveFitter;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class CurveFitterTest {
    @Test
    public void testMath303() {
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        CurveFitter fitter = new CurveFitter((DifferentiableMultivariateVectorOptimizer)optimizer);
        fitter.addObservedPoint(2.805, 0.6934785852953367);
        fitter.addObservedPoint(2.74333333333333, 0.6306772025518496);
        fitter.addObservedPoint(1.655, 0.9474675497289684);
        fitter.addObservedPoint(1.725, 0.9013594835804194);
        SimpleInverseFunction sif = new SimpleInverseFunction();
        double[] initialguess1 = new double[]{1.0};
        Assert.assertEquals((long)1L, (long)fitter.fit((ParametricUnivariateFunction)sif, initialguess1).length);
        double[] initialguess2 = new double[]{1.0, 0.5};
        Assert.assertEquals((long)2L, (long)fitter.fit((ParametricUnivariateFunction)sif, initialguess2).length);
    }

    @Test
    public void testMath304() {
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        CurveFitter fitter = new CurveFitter((DifferentiableMultivariateVectorOptimizer)optimizer);
        fitter.addObservedPoint(2.805, 0.6934785852953367);
        fitter.addObservedPoint(2.74333333333333, 0.6306772025518496);
        fitter.addObservedPoint(1.655, 0.9474675497289684);
        fitter.addObservedPoint(1.725, 0.9013594835804194);
        SimpleInverseFunction sif = new SimpleInverseFunction();
        double[] initialguess1 = new double[]{1.0};
        Assert.assertEquals((double)1.6357215104109237, (double)fitter.fit((ParametricUnivariateFunction)sif, initialguess1)[0], (double)1.0E-14);
        double[] initialguess2 = new double[]{10.0};
        Assert.assertEquals((double)1.6357215104109237, (double)fitter.fit((ParametricUnivariateFunction)sif, initialguess1)[0], (double)1.0E-14);
    }

    @Test
    public void testMath372() {
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        CurveFitter curveFitter = new CurveFitter((DifferentiableMultivariateVectorOptimizer)optimizer);
        curveFitter.addObservedPoint(15.0, 4443.0);
        curveFitter.addObservedPoint(31.0, 8493.0);
        curveFitter.addObservedPoint(62.0, 17586.0);
        curveFitter.addObservedPoint(125.0, 30582.0);
        curveFitter.addObservedPoint(250.0, 45087.0);
        curveFitter.addObservedPoint(500.0, 50683.0);
        ParametricUnivariateFunction f = new ParametricUnivariateFunction(){

            public double value(double x, double ... parameters) {
                double a = parameters[0];
                double b = parameters[1];
                double c = parameters[2];
                double d = parameters[3];
                return d + (a - d) / (1.0 + FastMath.pow((double)(x / c), (double)b));
            }

            public double[] gradient(double x, double ... parameters) {
                double a = parameters[0];
                double b = parameters[1];
                double c = parameters[2];
                double d = parameters[3];
                double[] gradients = new double[4];
                double den = 1.0 + FastMath.pow((double)(x / c), (double)b);
                gradients[0] = 1.0 / den;
                gradients[1] = -((a - d) * FastMath.pow((double)(x / c), (double)b) * FastMath.log((double)(x / c))) / (den * den);
                gradients[2] = b * FastMath.pow((double)(x / c), (double)(b - 1.0)) * (x / (c * c)) * (a - d) / (den * den);
                gradients[3] = 1.0 - 1.0 / den;
                return gradients;
            }
        };
        double[] initialGuess = new double[]{1500.0, 0.95, 65.0, 35000.0};
        double[] estimatedParameters = curveFitter.fit(f, initialGuess);
        Assert.assertEquals((double)2411.0, (double)estimatedParameters[0], (double)500.0);
        Assert.assertEquals((double)1.62, (double)estimatedParameters[1], (double)0.04);
        Assert.assertEquals((double)111.22, (double)estimatedParameters[2], (double)0.3);
        Assert.assertEquals((double)55347.47, (double)estimatedParameters[3], (double)300.0);
        Assert.assertTrue((optimizer.getRMS() < 600.0 ? 1 : 0) != 0);
    }

    private static class SimpleInverseFunction
    implements ParametricUnivariateFunction {
        private SimpleInverseFunction() {
        }

        public double value(double x, double ... parameters) {
            return parameters[0] / x + (parameters.length < 2 ? 0.0 : parameters[1]);
        }

        public double[] gradient(double x, double ... doubles) {
            double[] gradientVector = new double[doubles.length];
            gradientVector[0] = 1.0 / x;
            if (doubles.length >= 2) {
                gradientVector[1] = 1.0;
            }
            return gradientVector;
        }
    }
}

