/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

final class Interpolation {
    private Interpolation() {
    }

    static double mean(double x, double y) {
        double v = x + y;
        if (Double.isFinite(v)) {
            return v * 0.5;
        }
        return x * 0.5 + y * 0.5;
    }

    static double mean(int x, int y) {
        return (double)((long)x + (long)y) * 0.5;
    }

    static double interpolate(double a, double b, double t) {
        if (a <= 0.0 && b >= 0.0) {
            return t * b + (1.0 - t) * a;
        }
        if (a == b) {
            return a;
        }
        return a + t * (b - a);
    }
}

