/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.documentation.options.AntOption;
import org.apache.rat.tools.MavenGenerator;
import org.apache.rat.utils.CasedString;

public final class AntGenerator {
    private static final Map<OptionCollection.ArgumentType, GenerateType> GENERATE_TYPE_MAP = new HashMap<OptionCollection.ArgumentType, GenerateType>();

    private AntGenerator() {
    }

    private static String argsKey(Option option) {
        return StringUtils.defaultIfEmpty(option.getLongOpt(), option.getOpt());
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 3) {
            System.err.println("At least three arguments are required: package, simple class name, target directory.");
            return;
        }
        String packageName = args[0];
        String className = args[1];
        String destDir = args[2];
        List<AntOption> options = AntOption.getAntOptions();
        String pkgName = String.join((CharSequence)File.separator, new CasedString(CasedString.StringCase.DOT, packageName).getSegments());
        File file = new File(new File(new File(destDir), pkgName), className + ".java");
        file.getParentFile().mkdirs();
        try (InputStream template = AntGenerator.class.getResourceAsStream("/Ant.tpl");
             FileWriter writer = new FileWriter(file);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();
             OutputStreamWriter customClasses = new OutputStreamWriter(bos);){
            if (template == null) {
                throw new RuntimeException("Template /Ant.tpl not found");
            }
            LineIterator iter = IOUtils.lineIterator(new InputStreamReader(template, StandardCharsets.UTF_8));
            block43: while (iter.hasNext()) {
                String line = iter.next();
                switch (line.trim()) {
                    case "${static}": {
                        for (Map.Entry<String, String> entry : AntOption.getRenameMap().entrySet()) {
                            writer.append(String.format("        xlateName.put(\"%s\", \"%s\");%n", entry.getKey(), entry.getValue()));
                        }
                        for (Option option : AntOption.getFilteredOptions()) {
                            writer.append(String.format("        unsupportedArgs.add(\"%s\");%n", AntGenerator.argsKey(option)));
                        }
                        for (AntOption antOption : options) {
                            if (!antOption.isDeprecated()) continue;
                            writer.append(String.format("        deprecatedArgs.put(\"%s\", \"%s\");%n", AntGenerator.argsKey(antOption.getOption()), String.format("Use of deprecated option '%s'. %s", antOption.getName(), antOption.getDeprecated())));
                        }
                        continue block43;
                    }
                    case "${methods}": {
                        AntGenerator.writeMethods(writer, options, customClasses);
                        break;
                    }
                    case "${package}": {
                        writer.append(String.format("package %s;%n", packageName));
                        break;
                    }
                    case "${constructor}": {
                        writer.append(String.format("    protected %s() {\n        setDeprecationReporter();\n    }%n", className));
                        break;
                    }
                    case "${class}": {
                        writer.append(String.format("public abstract class %s extends Task {%n", className));
                        break;
                    }
                    case "${classes}": {
                        customClasses.flush();
                        customClasses.close();
                        writer.write(bos.toString());
                        break;
                    }
                    case "${commonArgs}": {
                        InputStream argsTpl = MavenGenerator.class.getResourceAsStream("/Args.tpl");
                        try {
                            if (argsTpl == null) {
                                throw new RuntimeException("Args.tpl not found");
                            }
                            IOUtils.copy(argsTpl, (Writer)writer, StandardCharsets.UTF_8);
                            continue block43;
                        }
                        finally {
                            if (argsTpl == null) continue block43;
                            argsTpl.close();
                            continue block43;
                        }
                    }
                    default: {
                        writer.append(line).append(System.lineSeparator());
                    }
                }
            }
        }
    }

    private static void writeMethods(FileWriter writer, List<AntOption> options, Writer customClasses) throws IOException {
        for (AntOption option : options) {
            if (option.isAttribute()) {
                writer.append(option.getComment(true));
                writer.append(String.format("    public void %s {%n%s%n    }%n%n", option.getAttributeFunctionName(), AntGenerator.getAttributeBody(option)));
                continue;
            }
            customClasses.append(option.getComment(false));
            customClasses.append(String.format("    public %1$s create%1$s() {%n        return new %1$s();%n    }%n%n", WordUtils.capitalize(option.getName())));
            customClasses.append(AntGenerator.getElementClass(option));
        }
    }

    private static String getAttributeBody(AntOption option) {
        return option.hasArg() ? String.format("        setArg(%s, %s);%n", option.keyValue(), option.getName()) : String.format("        if (%1$s) { setArg(%2$s, null); } else { removeArg(%2$s); }", option.getName(), option.keyValue());
    }

    private static String getElementClass(AntOption option) {
        String elementConstructor = "    public class %1$s {\n        %1$s() { }\n\n";
        String funcName = WordUtils.capitalize(option.getName());
        StringBuilder result = new StringBuilder(String.format(elementConstructor, funcName));
        HashSet<AntOption> implementedOptions = new HashSet<AntOption>();
        implementedOptions.add(option);
        option.convertedFrom().stream().filter(o -> !AntOption.getUnsupportedOptions().contains(o)).forEach(opt -> implementedOptions.add(new AntOption((Option)opt)));
        implementedOptions.forEach(o -> result.append(GENERATE_TYPE_MAP.get((Object)o.getArgType()).getPattern(option, (AntOption)o)));
        result.append(String.format("    }%n", new Object[0]));
        return result.toString();
    }

    static {
        final String defaultFmt = "        public void add%$1s(String %2$s) {%n            addArg(%%1$s, %2$s);%n        }%n%n";
        for (OptionCollection.ArgumentType type : OptionCollection.ArgumentType.values()) {
            GenerateType generateType;
            switch (type) {
                case FILE: 
                case DIRORARCHIVE: {
                    generateType = new GenerateType("fileset"){

                        @Override
                        protected String getMethodFormat(AntOption antOption) {
                            return "        public void addConfiguredFileset(FileSet fileSet) {\n            for (Resource resource : fileSet) {\n                if (resource.isFilesystemOnly()) {\n                    addArg(%1$s, ((FileResource) resource).getFile().getAbsolutePath());\n                }\n            }\n        }\n\n";
                        }
                    };
                    break;
                }
                case NONE: {
                    generateType = new GenerateType(""){

                        @Override
                        protected String getMethodFormat(AntOption antOption) {
                            return "";
                        }
                    };
                    break;
                }
                case STANDARDCOLLECTION: {
                    generateType = new GenerateType("Std");
                    break;
                }
                case EXPRESSION: {
                    generateType = new GenerateType("Expr");
                    break;
                }
                case COUNTERPATTERN: {
                    generateType = new GenerateType("Cntr");
                    break;
                }
                case LICENSEID: 
                case FAMILYID: {
                    generateType = new GenerateType("Lst");
                    break;
                }
                default: {
                    generateType = new GenerateType(type.getDisplayName()){

                        @Override
                        protected String getMethodFormat(AntOption antOption) {
                            return String.format(defaultFmt, this.innerClass, WordUtils.uncapitalize(antOption.getArgName()));
                        }
                    };
                }
            }
            GENERATE_TYPE_MAP.put(type, generateType);
        }
    }

    public static class GenerateType {
        protected final String innerClass;

        GenerateType(String innerClass) {
            this.innerClass = innerClass;
        }

        protected String getMethodFormat(AntOption antOption) {
            return String.format("        public void addConfigured%1$s(%1$s %%2$s) {\n            addArg(%%1$s, %%2$s.value);\n        }\n\n", this.innerClass);
        }

        public String getPattern(AntOption delegateOption, AntOption antOption) {
            if (delegateOption.isAttribute()) {
                String fmt = "<rat:report %s='%s' />";
                return String.format(fmt, delegateOption.getName(), antOption.hasArg() ? antOption.getArgName() : "true");
            }
            return String.format(this.getMethodFormat(antOption), antOption.keyValue(), WordUtils.uncapitalize(antOption.getArgName()));
        }
    }
}

