/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.ArchiveEntryDocument;
import org.apache.rat.document.ArchiveEntryName;
import org.apache.rat.document.DocumentName;
import org.apache.rat.report.RatReport;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.walker.Walker;

public class ArchiveWalker
extends Walker {
    public ArchiveWalker(Document document) {
        super(document);
    }

    @Override
    public void run(RatReport report) throws RatException {
        for (Document document : this.getDocuments()) {
            report.report(document);
        }
    }

    private InputStream createInputStream() throws IOException {
        return new BufferedInputStream(this.getDocument().inputStream());
    }

    public Collection<Document> getDocuments() throws RatException {
        ArrayList<Document> result = new ArrayList<Document>();
        try (Object input = new ArchiveStreamFactory().createArchiveInputStream(this.createInputStream());){
            Object entry;
            while ((entry = ((ArchiveInputStream)input).getNextEntry()) != null) {
                if (entry.isDirectory() || !((ArchiveInputStream)input).canReadEntryData((ArchiveEntry)entry)) continue;
                DocumentName innerName = DocumentName.builder().setName(entry.getName()).setBaseName(".").build();
                if (!this.getDocument().getNameMatcher().matches(innerName)) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy(input, (OutputStream)baos);
                ArchiveEntryName entryName = new ArchiveEntryName(this.getDocument().getName(), entry.getName());
                result.add(new ArchiveEntryDocument(entryName, baos.toByteArray(), this.getDocument().getNameMatcher()));
            }
        }
        catch (ArchiveException e) {
            DefaultLog.getInstance().warn(String.format("Unable to process %s: %s", this.getDocument().getName(), e.getMessage()));
        }
        catch (IOException e) {
            throw RatException.makeRatException(e);
        }
        return result;
    }
}

