/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.outbound;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.cxf.common.logging.LogUtils;

public class DefaultConnectionManager
implements ConnectionManager,
ConnectionEventListener {
    private static final long serialVersionUID = -8931949400870739450L;
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultConnectionManager.class);

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("allocateConnection cxRequestInfo = " + cxRequestInfo);
        }
        ManagedConnection mc = mcf.createManagedConnection(null, cxRequestInfo);
        mc.addConnectionEventListener((ConnectionEventListener)this);
        return mc.getConnection(null, cxRequestInfo);
    }

    public void connectionClosed(ConnectionEvent event) {
        try {
            ((ManagedConnection)event.getSource()).destroy();
        }
        catch (ResourceException e) {
            LOG.log(Level.SEVERE, "Failed to destroy connection.", e);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            ((ManagedConnection)event.getSource()).destroy();
        }
        catch (ResourceException e) {
            LOG.log(Level.SEVERE, "Failed to destroy connection.", e);
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }
}

