/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tdigest;

import org.apache.datasketches.common.Shuffle;
import org.apache.datasketches.tdigest.Sort;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SortTest {
    @Test
    public void smallWithRepetition() {
        double[] keys = new double[]{3.0, 1.0, 4.0, 2.0, 1.0};
        long[] values = new long[]{4L, 1L, 5L, 3L, 2L};
        Sort.stableSort((double[])keys, (long[])values, (int)keys.length);
        Assert.assertEquals((double)keys[0], (double)1.0);
        Assert.assertEquals((double)keys[1], (double)1.0);
        Assert.assertEquals((double)keys[2], (double)2.0);
        Assert.assertEquals((double)keys[3], (double)3.0);
        Assert.assertEquals((double)keys[4], (double)4.0);
        Assert.assertEquals((long)values[0], (long)1L);
        Assert.assertEquals((long)values[1], (long)2L);
        Assert.assertEquals((long)values[2], (long)3L);
        Assert.assertEquals((long)values[3], (long)4L);
        Assert.assertEquals((long)values[4], (long)5L);
    }

    @Test
    public void large() {
        int i;
        int n = 1000;
        double[] keys = new double[1000];
        long[] values = new long[1000];
        for (i = 0; i < 1000; ++i) {
            values[i] = i;
        }
        Shuffle.shuffle(values);
        for (i = 0; i < 1000; ++i) {
            keys[i] = values[i];
        }
        Sort.stableSort((double[])keys, (long[])values, (int)1000);
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)keys[i], (double)i);
            Assert.assertEquals((long)values[i], (long)i);
        }
    }
}

