/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.BinomialBoundsN;
import org.apache.datasketches.thetacommon.HashOperations;

public abstract class ThetaSketch
implements MemorySegmentStatus {
    ThetaSketch() {
    }

    public static ThetaSketch heapify(MemorySegment srcSeg) {
        return ThetaSketch.heapify(srcSeg, 9001L);
    }

    public static ThetaSketch heapify(MemorySegment srcSeg, long expectedSeed) {
        PreambleUtil.checkSegPreambleCap(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        if (familyID == Family.COMPACT.getID()) {
            return CompactThetaSketch.heapify(srcSeg, expectedSeed);
        }
        return ThetaSketch.heapifyUpdateSketchFromMemorySegment(srcSeg, expectedSeed);
    }

    public static ThetaSketch wrap(MemorySegment srcSeg) {
        return ThetaSketch.wrap(srcSeg, 9001L);
    }

    public static ThetaSketch wrap(MemorySegment srcSeg, long expectedSeed) {
        PreambleUtil.checkSegPreambleCap(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        if (familyID == Family.QUICKSELECT.getID()) {
            return DirectQuickSelectSketchR.readOnlyWrap(srcSeg, expectedSeed);
        }
        if (familyID == Family.COMPACT.getID()) {
            return CompactThetaSketch.wrap(srcSeg, expectedSeed);
        }
        Family family = Family.idToFamily(familyID);
        throw new SketchesArgumentException("Cannot wrap family: " + String.valueOf((Object)family) + " as a ThetaSketch");
    }

    public CompactThetaSketch compact() {
        return this.isCompact() ? (CompactThetaSketch)this : this.compact(true, null);
    }

    public abstract CompactThetaSketch compact(boolean var1, MemorySegment var2);

    public abstract int getCompactBytes();

    public int getCountLessThanThetaLong(long thetaLong) {
        return HashOperations.count(this.getCache(), thetaLong);
    }

    public abstract int getCurrentBytes();

    public abstract double getEstimate();

    public static double getEstimate(MemorySegment srcSeg) {
        PreambleUtil.checkSegPreambleCap(srcSeg);
        int familyId = PreambleUtil.extractFamilyID(srcSeg);
        if (!ThetaSketch.isValidSketchID(familyId)) {
            throw new SketchesArgumentException("Source MemorySegment is not a valid ThetaSketch Family: " + Family.idToFamily(familyId).toString());
        }
        return ThetaSketch.estimate(PreambleUtil.extractThetaLong(srcSeg), ThetaSketch.getRetainedEntries(srcSeg));
    }

    public abstract Family getFamily();

    public double getLowerBound(int numStdDev) {
        return this.isEstimationMode() ? ThetaSketch.lowerBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        if (numberOfEntries == 0) {
            return 8;
        }
        if (numberOfEntries == 1) {
            return 16;
        }
        return (numberOfEntries << 3) + 24;
    }

    public static int getCompactSketchMaxBytes(int lgNomEntries) {
        return (int)((double)(2 << lgNomEntries) * 0.9375 + (double)Family.QUICKSELECT.getMaxPreLongs()) * 8;
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public static int getUpdateSketchMaxBytes(int lgNomEntries) {
        return (16 << lgNomEntries) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public int getRetainedEntries() {
        return this.getRetainedEntries(true);
    }

    public abstract int getRetainedEntries(boolean var1);

    public static int getRetainedEntries(MemorySegment srcSeg) {
        boolean empty;
        int preLongs = PreambleUtil.checkSegPreambleCap(srcSeg);
        boolean bl = empty = (PreambleUtil.extractFlags(srcSeg) & 4) != 0;
        return preLongs == 1 ? (empty ? 0 : 1) : PreambleUtil.extractCurCount(srcSeg);
    }

    public static int getSerializationVersion(MemorySegment seg) {
        PreambleUtil.checkSegPreambleCap(seg);
        return PreambleUtil.extractSerVer(seg);
    }

    public double getTheta() {
        return (double)this.getThetaLong() / 9.223372036854776E18;
    }

    public abstract long getThetaLong();

    public double getUpperBound(int numStdDev) {
        return this.isEstimationMode() ? ThetaSketch.upperBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public abstract boolean isCompact();

    public abstract boolean isEmpty();

    public boolean isEstimationMode() {
        return this.getThetaLong() < Long.MAX_VALUE && !this.isEmpty();
    }

    public abstract boolean isOrdered();

    public abstract HashIterator iterator();

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false, 8, true);
    }

    public String toString(boolean sketchSummary, boolean dataDetail, int width, boolean hexMode) {
        StringBuilder sb = new StringBuilder();
        int nomLongs = 0;
        int arrLongs = 0;
        float p = 0.0f;
        int rf = 0;
        boolean updateSketch = this instanceof UpdatableThetaSketch;
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        if (updateSketch) {
            UpdatableThetaSketch uis = (UpdatableThetaSketch)this;
            nomLongs = 1 << uis.getLgNomLongs();
            arrLongs = 1 << uis.getLgArrLongs();
            p = uis.getP();
            rf = uis.getResizeFactor().getValue();
        }
        if (dataDetail) {
            int w;
            int n = w = width > 0 ? width : 8;
            if (curCount > 0) {
                sb.append("### SKETCH DATA DETAIL");
                HashIterator it = this.iterator();
                int j = 0;
                while (it.next()) {
                    long h = it.get();
                    if (j % w == 0) {
                        sb.append(Util.LS).append(String.format("   %6d", j + 1));
                    }
                    if (hexMode) {
                        sb.append(" " + Util.zeroPad(Long.toHexString(h), 16) + ",");
                    } else {
                        sb.append(String.format(" %20d,", h));
                    }
                    ++j;
                }
                sb.append(Util.LS).append("### END DATA DETAIL").append(Util.LS + Util.LS);
            }
        }
        if (sketchSummary) {
            double thetaDbl = (double)thetaLong / 9.223372036854776E18;
            String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
            String thisSimpleName = this.getClass().getSimpleName();
            int seedHash = Short.toUnsignedInt(this.getSeedHash());
            sb.append(Util.LS);
            sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            if (updateSketch) {
                sb.append("   Nominal Entries (k)     : ").append(nomLongs).append(Util.LS);
            }
            sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
            sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
            sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
            if (updateSketch) {
                sb.append("   p                       : ").append(p).append(Util.LS);
            }
            sb.append("   Theta (double)          : ").append(thetaDbl).append(Util.LS);
            sb.append("   Theta (long)            : ").append(thetaLong).append(Util.LS);
            sb.append("   Theta (long) hex        : ").append(thetaHex).append(Util.LS);
            sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
            sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
            sb.append("   Ordered?                : ").append(this.isOrdered()).append(Util.LS);
            if (updateSketch) {
                sb.append("   Resize Factor           : ").append(rf).append(Util.LS);
                sb.append("   Array Size Entries      : ").append(arrLongs).append(Util.LS);
            }
            sb.append("   Retained Entries        : ").append(curCount).append(Util.LS);
            sb.append("   Seed Hash               : ").append(Integer.toHexString(seedHash)).append(" | ").append(seedHash).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.preambleToString(byteArr);
    }

    public static String toString(MemorySegment seg) {
        return PreambleUtil.preambleToString(seg);
    }

    abstract long[] getCache();

    abstract int getCompactPreambleLongs();

    abstract int getCurrentDataLongs();

    abstract int getCurrentPreambleLongs();

    MemorySegment getMemorySegment() {
        return null;
    }

    abstract short getSeedHash();

    static boolean getEmpty(MemorySegment srcSeg) {
        PreambleUtil.checkSegPreambleCap(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        if (serVer == 1) {
            return ThetaSketch.getThetaLong(srcSeg) == Long.MAX_VALUE && ThetaSketch.getRetainedEntries(srcSeg) == 0;
        }
        return (PreambleUtil.extractFlags(srcSeg) & 4) != 0;
    }

    static int getPreambleLongs(MemorySegment srcSeg) {
        return PreambleUtil.checkSegPreambleCap(srcSeg);
    }

    static long getThetaLong(MemorySegment srcSeg) {
        int preLongs = PreambleUtil.checkSegPreambleCap(srcSeg);
        return preLongs < 3 ? Long.MAX_VALUE : PreambleUtil.extractThetaLong(srcSeg);
    }

    static final boolean isValidSketchID(int id) {
        return id == Family.ALPHA.getID() || id == Family.QUICKSELECT.getID() || id == Family.COMPACT.getID();
    }

    static final double estimate(long thetaLong, int curCount) {
        return (double)curCount * (9.223372036854776E18 / (double)thetaLong);
    }

    public static double getLowerBound(int numStdDev, MemorySegment srcSeg) {
        return ThetaSketch.lowerBound(ThetaSketch.getRetainedEntries(srcSeg), ThetaSketch.getThetaLong(srcSeg), numStdDev, ThetaSketch.getEmpty(srcSeg));
    }

    static final double lowerBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getLowerBound(curCount, theta, numStdDev, empty);
    }

    public static double getUpperBound(int numStdDev, MemorySegment srcSeg) {
        return ThetaSketch.upperBound(ThetaSketch.getRetainedEntries(srcSeg), ThetaSketch.getThetaLong(srcSeg), numStdDev, ThetaSketch.getEmpty(srcSeg));
    }

    static final double upperBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getUpperBound(curCount, theta, numStdDev, empty);
    }

    private static final ThetaSketch heapifyUpdateSketchFromMemorySegment(MemorySegment srcSeg, long expectedSeed) {
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(srcSeg));
        if (family == Family.ALPHA) {
            boolean compactFlag;
            int flags = PreambleUtil.extractFlags(srcSeg);
            boolean bl = compactFlag = (flags & 8) != 0;
            if (compactFlag) {
                throw new SketchesArgumentException("Corrupted: An ALPHA family image cannot be compact");
            }
            return HeapAlphaSketch.heapifyInstance(srcSeg, expectedSeed);
        }
        if (family == Family.QUICKSELECT) {
            return HeapQuickSelectSketch.heapifyInstance(srcSeg, expectedSeed);
        }
        throw new SketchesArgumentException("Cannot heapify family: " + String.valueOf((Object)family) + " as a ThetaSketch");
    }
}

