/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.BoundsOnRatiosInSampledSets;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.ThetaSketch;

public final class BoundsOnRatiosInThetaSketchedSets {
    private BoundsOnRatiosInThetaSketchedSets() {
    }

    public static double getLowerBoundForBoverA(ThetaSketch sketchA, ThetaSketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getLowerBoundForBoverA(countA, countB, f);
    }

    public static double getUpperBoundForBoverA(ThetaSketch sketchA, ThetaSketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 1.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getUpperBoundForBoverA(countA, countB, f);
    }

    public static double getEstimateOfBoverA(ThetaSketch sketchA, ThetaSketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.5;
        }
        return (double)countB / (double)countA;
    }

    static void checkThetas(long thetaLongA, long thetaLongB) {
        if (thetaLongB > thetaLongA) {
            throw new SketchesArgumentException("ThetaLongB cannot be > ThetaLongA.");
        }
    }
}

