/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.dsmlv2.AbstractDsmlMessageDecorator;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Request;
import org.dom4j.Element;

public abstract class AbstractRequestDsml<E extends Request>
extends AbstractDsmlMessageDecorator<E>
implements Request {
    public AbstractRequestDsml(LdapApiService codec, E ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public Element toDsml(Element root) {
        Element element = root.addElement(this.getRequestName());
        int requestID = ((Request)this.getDecorated()).getMessageId();
        if (requestID > 0) {
            element.addAttribute("requestID", Integer.toString(requestID));
        }
        ParserUtils.addControls(this.getCodecService(), element, ((Request)this.getDecorated()).getControls().values(), true);
        return element;
    }

    protected String getRequestName() {
        switch (((Request)this.getDecorated()).getType()) {
            case ABANDON_REQUEST: {
                return "abandonRequest";
            }
            case ADD_REQUEST: {
                return "addRequest";
            }
            case BIND_REQUEST: {
                return "authRequest";
            }
            case COMPARE_REQUEST: {
                return "compareRequest";
            }
            case DEL_REQUEST: {
                return "delRequest";
            }
            case EXTENDED_REQUEST: {
                return "extendedRequest";
            }
            case MODIFYDN_REQUEST: {
                return "modDNRequest";
            }
            case MODIFY_REQUEST: {
                return "modifyRequest";
            }
            case SEARCH_REQUEST: {
                return "searchRequest";
            }
        }
        return "error";
    }

    public int computeLength() {
        return 0;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    public boolean hasResponse() {
        return ((Request)this.getDecorated()).hasResponse();
    }
}

