/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.response;

import org.apache.commons.text.StringEscapeUtils;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.response.AbstractResultResponseDsml;
import org.apache.directory.api.dsmlv2.response.LdapResultDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedResponse;
import org.apache.directory.api.util.Strings;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;

public class ExtendedResponseDsml
extends AbstractResultResponseDsml<ExtendedResponse>
implements ExtendedResponse {
    private byte[] response;

    public ExtendedResponseDsml(LdapApiService codec) {
        super(codec, new OpaqueExtendedResponse(""));
    }

    public ExtendedResponseDsml(LdapApiService codec, ExtendedResponse ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((ExtendedResponse)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        byte[] responseValue;
        Object element = root != null ? root.addElement("extendedResponse") : new DefaultElement("extendedResponse");
        ExtendedResponse extendedResponse = (ExtendedResponse)this.getDecorated();
        LdapResultDsml ldapResultDsml = new LdapResultDsml(this.getCodecService(), ((ExtendedResponse)this.getDecorated()).getLdapResult(), (Message)this.getDecorated());
        ldapResultDsml.toDsml((Element)element);
        String responseName = extendedResponse.getResponseName();
        if (responseName != null) {
            element.addElement("responseName").addText(responseName);
        }
        if ((responseValue = this.getResponseValue()) != null) {
            if (ParserUtils.needsBase64Encoding(responseValue)) {
                Namespace xsdNamespace = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
                Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                element.getDocument().getRootElement().add(xsdNamespace);
                element.getDocument().getRootElement().add(xsiNamespace);
                Element responseElement = element.addElement("response").addText(ParserUtils.base64Encode(responseValue));
                responseElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
            } else {
                element.addElement("response").addText(StringEscapeUtils.escapeXml11((String)Strings.utf8ToString((byte[])responseValue)));
            }
        }
        return element;
    }

    public void setResponseName(String oid) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(oid);
    }

    public String getResponseName() {
        return ((ExtendedResponse)this.getDecorated()).getResponseName();
    }

    public void setResponseName(Oid responseName) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(responseName.toString());
    }

    public byte[] getResponseValue() {
        return this.response;
    }

    public void setResponseValue(byte[] responseValue) {
        this.response = responseValue;
    }
}

