// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("test_aggregate_table") {
    def dbName = "test_aggregate_db"
    List<List<Object>> db = sql """show databases like '${dbName}'"""
    if (db.size() == 0) {
        sql """CREATE DATABASE ${dbName}"""
    }

    sql """use ${dbName}"""

    sql """DROP TABLE IF EXISTS int_agg"""
    sql """
            CREATE TABLE IF NOT EXISTS int_agg (
                k int,
                int_value_sum int sum,
                int_value_max int max,
                int_value_min int min,
                int_value_replace int replace,
                int_value_replace_if_not_null int replace_if_not_null
            )
            AGGREGATE KEY(k)
            DISTRIBUTED BY HASH(k) BUCKETS 5 properties("replication_num" = "1");
        """
    sql """insert into int_agg values(0, 1, 1, 1, 1, 1)"""
    sql """insert into int_agg values(0, 2, 2, 2, 2, 2)"""
    sql """insert into int_agg values(0, null, null, null, null, null)"""
    qt_int_agg_table """select * from int_agg"""
    qt_desc_date_table """desc int_agg"""
    sql """DROP TABLE int_agg"""

    sql """DROP TABLE IF EXISTS string_agg"""
    sql """
            CREATE TABLE IF NOT EXISTS string_agg (
                k int,
                char_value_max char(10) max,
                char_value_min char(10) min,
                char_value_replace char(10) replace,
                char_value_replace_if_not_null char(10) replace_if_not_null
            )
            AGGREGATE KEY(k)
            DISTRIBUTED BY HASH(k) BUCKETS 5 properties("replication_num" = "1");
        """
    sql """insert into string_agg values(0, '1', '1', '1', '1')"""
    sql """insert into string_agg values(0, '2', '2', '2', '2')"""
    sql """insert into string_agg values(0, '', '', '', '')"""
    sql """insert into string_agg values(0, null, null, null, null)"""
    qt_string_agg_table """select * from string_agg"""
    qt_desc_string_table """desc string_agg"""
    sql """DROP TABLE string_agg"""

    sql """DROP TABLE IF EXISTS date_agg"""
    sql """
            CREATE TABLE IF NOT EXISTS date_agg (
                k int,
                date_value_max date max,
                date_value_min date min,
                date_value_replace date replace,
                date_value_replace_if_not_null date replace_if_not_null,
                datev2_value_max datev2 max,
                datev2_value_min datev2 min,
                datev2_value_replace datev2 replace,
                datev2_value_replace_if_not_null datev2 replace_if_not_null,
                datetimev2_value_max datetimev2 max,
                datetimev2_value_min datetimev2 min,
                datetimev2_value_replace datetimev2 replace,
                datetimev2_value_replace_if_not_null datetimev2 replace_if_not_null,
                datetimev2_value_max_1 datetimev2(3) max,
                datetimev2_value_min_1 datetimev2(3) min,
                datetimev2_value_replace_1 datetimev2(3) replace,
                datetimev2_value_replace_if_not_null_1 datetimev2(3) replace_if_not_null,
                datetimev2_value_max_2 datetimev2(6) max,
                datetimev2_value_min_2 datetimev2(6) min,
                datetimev2_value_replace_2 datetimev2(6) replace,
                datetimev2_value_replace_if_not_null_2 datetimev2(6) replace_if_not_null
            )
            AGGREGATE KEY(k)
            DISTRIBUTED BY HASH(k) BUCKETS 5 properties("replication_num" = "1");
        """
    sql """insert into date_agg values(0, '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111', '2000-01-01 11:11:11.111111') """
    sql """insert into date_agg values(0, '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111', '2000-12-31 11:11:11.111111') """
    sql """insert into date_agg values(0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null) """
    qt_date_agg_table """select * from date_agg"""
    qt_desc_date_table """desc date_agg"""
    sql """DROP TABLE date_agg"""

    sql """DROP TABLE IF EXISTS test_string_agg_with_null"""
    sql """ 
        CREATE TABLE `test_string_agg_with_null` (
            `col1` tinyint NOT NULL,
            `col2` int NOT NULL,
            `col3` tinyint NOT NULL,
            `col5` boolean REPLACE NOT NULL,
            `col4` datetime(2) REPLACE NOT NULL,
            `col6` double REPLACE_IF_NOT_NULL NULL,
            `col7` varchar(100) REPLACE_IF_NOT_NULL NULL
        ) ENGINE=OLAP
        AGGREGATE KEY(`col1`, `col2`, `col3`)
        DISTRIBUTED BY HASH(`col1`, `col2`, `col3`) BUCKETS 1
        PROPERTIES (
            "replication_allocation" = "tag.location.default: 1",
            "disable_auto_compaction" = "true"
        ); 
    """

    sql """ insert into test_string_agg_with_null values
        ( -100 ,    1 ,  -82 ,    1 , '2024-02-16 04:37:37.00' , -1299962421.904282 , NULL ),
        ( -100 ,    0 ,  -82 ,    1 , '2024-02-16 04:37:37.00' , -1299962421.904282 , "hi" ),
        ( -100 ,    1 ,   92 ,    1 , '2024-02-16 04:37:37.00' ,   23423423.0324234 , "NULL" );
    """

    sql """ insert into test_string_agg_with_null values
        ( -100 ,    1 ,  1 ,    1 , '2024-02-16 04:37:37.00' , 1399962421.904282 , "doris" );
        """
    
    qt_string_agg_table_with_null """ select * from test_string_agg_with_null """
    sql """DROP TABLE test_string_agg_with_null"""

}
