// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("regression_test_variant_with_bf", "nonConcurrent,p0"){
    def table_name = "var_with_bloom_filter"
    sql "DROP TABLE IF EXISTS var_with_bloom_filter"
    sql """
        CREATE TABLE IF NOT EXISTS var_with_bloom_filter (
            k bigint,
            v variant<properties("variant_max_subcolumns_count" = "10")>
        )
        DUPLICATE KEY(`k`)
        DISTRIBUTED BY HASH(k) BUCKETS 1
        properties("replication_num" = "1", "bloom_filter_columns" = "v", "bloom_filter_fpp" = "0.0001");
    """
    sql """insert into var_with_bloom_filter values (1, '{"a" : 123456}')"""
    sql """insert into var_with_bloom_filter values (2, '{"a" : 789111}')"""
    sql """insert into var_with_bloom_filter values (3, '{"a" : 789111}')"""
    

    sql """insert into var_with_bloom_filter values (1, '{"b" : "xxxxxxx"}')"""
    sql """insert into var_with_bloom_filter values (2, '{"b" : "yyyyyyy"}')"""
    sql """insert into var_with_bloom_filter values (3, '{"b" : "zzzzzzz"}')"""

    sql """insert into var_with_bloom_filter values (1, '{"b" : "xxxxxxx"}')"""
    sql """insert into var_with_bloom_filter values (2, '{"b" : "yyyyyyy"}')"""
    sql """insert into var_with_bloom_filter values (3, '{"b" : "zzzzzzz"}')"""

    // for (int i = 0; i < 10; i++) {
    //     sql """insert into var_with_bloom_filter values (${i}, '{"b" : "xxxxxxx ${i}"}')"""
    //     sql """insert into var_with_bloom_filter values (${i}, '{"b" : "yyyyyyy ${i}"}')"""
    //     sql """insert into var_with_bloom_filter values (${i}, '{"b" : "zzzzzzz ${i}"}')"""
    // }
    // trigger_and_wait_compaction("var_with_bloom_filter", "full")
    // try {
    //     GetDebugPoint().enableDebugPointForAllBEs("bloom_filter_must_filter_data")
    //     sql """ set enable_inverted_index_query = false """ 
    //     sql "select * from  var_with_bloom_filter where v['b'] = 'xxxxxxx 1'"
    // } finally {
    //     GetDebugPoint().disableDebugPointForAllBEs("bloom_filter_must_filter_data")
    // }
}