// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.exceptions.AnalysisException;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNullable;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullLiteral;
import org.apache.doris.nereids.trees.expressions.literal.Literal;
import org.apache.doris.nereids.trees.expressions.shape.TernaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.DataType;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.types.VarcharType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'regexp_replace_one'. This class is generated by GenerateFunction.
 */
public class RegexpReplaceOne extends ScalarFunction
        implements TernaryExpression, ExplicitlyCastableSignature, AlwaysNullable, PropagateNullLiteral {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(VarcharType.SYSTEM_DEFAULT, VarcharType.SYSTEM_DEFAULT, VarcharType.SYSTEM_DEFAULT),
            FunctionSignature.ret(StringType.INSTANCE)
                    .args(StringType.INSTANCE, StringType.INSTANCE, StringType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(VarcharType.SYSTEM_DEFAULT, VarcharType.SYSTEM_DEFAULT, VarcharType.SYSTEM_DEFAULT,
                            VarcharType.SYSTEM_DEFAULT),
            FunctionSignature.ret(StringType.INSTANCE)
                    .args(StringType.INSTANCE, StringType.INSTANCE, StringType.INSTANCE, StringType.INSTANCE)
    );

    /**
     * constructor with 3 arguments.
     */
    public RegexpReplaceOne(Expression arg0, Expression arg1, Expression arg2) {
        super("regexp_replace_one", arg0, arg1, arg2);
    }

    /**
     * constructor with 4 arguments.
     */
    public RegexpReplaceOne(Expression arg0, Expression arg1, Expression arg2, Expression arg3) {
        super("regexp_replace_one", arg0, arg1, arg2, arg3);
    }

    /** constructor for withChildren and reuse signature */
    private RegexpReplaceOne(ScalarFunctionParams functionParams) {
        super(functionParams);
    }

    /**
     * withChildren.
     */
    @Override
    public RegexpReplaceOne withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 3 || children.size() == 4,
                "RegexpReplaceOne should have 3 or 4 children");
        return new RegexpReplaceOne(getFunctionParams(children));
    }

    @Override
    public void checkLegalityBeforeTypeCoercion() {
        if (children().size() == 3) {
            return;
        }
        if (children().size() == 4) {
            Expression value = child(3);
            DataType type = value.getDataType();
            if (!type.isStringLikeType()) {
                throw new AnalysisException(
                        "The fourth param of regexp_replace_one must be a string type: " + this.toSql());
            }
            if (!(value instanceof Literal)) {
                throw new AnalysisException(
                        "The fourth param of regexp_replace_one must be a constant value: " + this.toSql());
            }
        }
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitRegexpReplaceOne(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
