// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.cdcclient.common;

public class Constants {
    public static final String DORIS_DELETE_SIGN = "__DORIS_DELETE_SIGN__";
    public static final long POLL_SPLIT_RECORDS_TIMEOUTS = 15000L;

    // Debezium default properties
    public static final long DEBEZIUM_HEARTBEAT_INTERVAL_MS = 10000L;
    public static final String DEBEZIUM_MAX_QUEUE_SIZE = "162580";
    public static final String DEBEZIUM_MAX_BATCH_SIZE = "40960";
    public static final String DEBEZIUM_POLL_INTERVAL_MS = "50";
}
