/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1TopologySelectorLabelRequirement;
import io.kubernetes.client.openapi.models.V1TopologySelectorLabelRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1TopologySelectorLabelRequirementFluentImpl<A extends V1TopologySelectorLabelRequirementFluent<A>>
extends BaseFluent<A>
implements V1TopologySelectorLabelRequirementFluent<A> {
    private String key;
    private List<String> values;

    public V1TopologySelectorLabelRequirementFluentImpl() {
    }

    public V1TopologySelectorLabelRequirementFluentImpl(V1TopologySelectorLabelRequirement instance) {
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withValues(instance.getValues());
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    @Override
    public Boolean hasKey() {
        return this.key != null;
    }

    @Override
    public A addToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(int index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(String ... items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public String getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove("values");
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TopologySelectorLabelRequirementFluentImpl that = (V1TopologySelectorLabelRequirementFluentImpl)o;
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }
}

