/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.FastNumberFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationAttemptId
implements Comparable<ApplicationAttemptId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appAttemptIdStrPrefix = "appattempt";
    private static final String APP_ATTEMPT_ID_PREFIX = "appattempt_";
    private static final int ATTEMPT_ID_MIN_DIGITS = 6;
    private static final int APP_ID_MIN_DIGITS = 4;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ApplicationAttemptId newInstance(ApplicationId appId, int attemptId) {
        ApplicationAttemptId appAttemptId = Records.newRecord(ApplicationAttemptId.class);
        appAttemptId.setApplicationId(appId);
        appAttemptId.setAttemptId(attemptId);
        appAttemptId.build();
        return appAttemptId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setAttemptId(int var1);

    public int hashCode() {
        int prime = 347671;
        int result = 5501;
        ApplicationId appId = this.getApplicationId();
        result = 347671 * result + appId.hashCode();
        result = 347671 * result + this.getAttemptId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttemptId other = (ApplicationAttemptId)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getAttemptId() == other.getAttemptId();
    }

    @Override
    public int compareTo(ApplicationAttemptId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getAttemptId() - other.getAttemptId();
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(APP_ATTEMPT_ID_PREFIX);
        ApplicationId appId = this.getApplicationId();
        sb.append(appId.getClusterTimestamp()).append('_');
        FastNumberFormat.format(sb, appId.getId(), 4);
        sb.append('_');
        FastNumberFormat.format(sb, this.getAttemptId(), 6);
        return sb.toString();
    }

    protected abstract void build();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationAttemptId fromString(String appAttemptIdStr) {
        if (!appAttemptIdStr.startsWith(APP_ATTEMPT_ID_PREFIX)) {
            throw new IllegalArgumentException("Invalid AppAttemptId prefix: " + appAttemptIdStr);
        }
        try {
            int pos1 = APP_ATTEMPT_ID_PREFIX.length() - 1;
            int pos2 = appAttemptIdStr.indexOf(95, pos1 + 1);
            if (pos2 < 0) {
                throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptIdStr);
            }
            long rmId = Long.parseLong(appAttemptIdStr.substring(pos1 + 1, pos2));
            int pos3 = appAttemptIdStr.indexOf(95, pos2 + 1);
            if (pos3 < 0) {
                throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptIdStr);
            }
            int appId = Integer.parseInt(appAttemptIdStr.substring(pos2 + 1, pos3));
            ApplicationId applicationId = ApplicationId.newInstance(rmId, appId);
            int attemptId = Integer.parseInt(appAttemptIdStr.substring(pos3 + 1));
            ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance(applicationId, attemptId);
            return applicationAttemptId;
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptIdStr, n);
        }
    }
}

