/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.deployment.rp.autoconf.AutoConfResource;
import org.apache.felix.deployment.rp.autoconf.ConfigurationAdminTask;
import org.apache.felix.deployment.rp.autoconf.PersistencyManager;
import org.osgi.framework.Filter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

class InstallOrUpdateResourceTask
implements ConfigurationAdminTask {
    private final AutoConfResource m_resource;

    public InstallOrUpdateResourceTask(AutoConfResource resource) {
        this.m_resource = resource;
    }

    public Filter getFilter() {
        return this.m_resource.getFilter();
    }

    public void run(PersistencyManager persistencyManager, ConfigurationAdmin configAdmin) throws Exception {
        Dictionary existingProperties;
        String name = this.m_resource.getName();
        Dictionary properties = this.m_resource.getProperties();
        String bundleLocation = this.m_resource.getBundleLocation();
        Configuration configuration = null;
        List<AutoConfResource> existingResources = null;
        try {
            existingResources = persistencyManager.load(name);
        }
        catch (IOException ioe) {
            throw new ResourceProcessorException(1, "Unable to read existing resources for resource " + name, ioe);
        }
        if (this.m_resource.isFactoryConfig()) {
            for (AutoConfResource existingResource : existingResources) {
                if (!this.m_resource.equalsTargetConfiguration(existingResource)) continue;
                configuration = configAdmin.getConfiguration(existingResource.getGeneratedPid(), bundleLocation);
                existingResources.remove(existingResource);
                break;
            }
            if (configuration == null) {
                configuration = configAdmin.createFactoryConfiguration(this.m_resource.getFactoryPid(), bundleLocation);
            }
            this.m_resource.setGeneratedPid(configuration.getPid());
        } else {
            for (AutoConfResource existingResource : existingResources) {
                if (!this.m_resource.getPid().equals(existingResource.getPid())) continue;
                existingResources.remove(existingResource);
                break;
            }
            if (!bundleLocation.equals((configuration = configAdmin.getConfiguration(this.m_resource.getPid(), bundleLocation)).getBundleLocation())) {
                throw new ResourceProcessorException(1, "Existing configuration was bound to " + configuration.getBundleLocation() + " instead of " + bundleLocation);
            }
        }
        if (this.m_resource.isMerge() && (existingProperties = configuration.getProperties()) != null) {
            Enumeration keys = existingProperties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                properties.put(key, existingProperties.get(key));
            }
        }
        configuration.update(properties);
    }
}

