/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.manipulation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.test.scenarios.component.Marker;
import org.apache.felix.ipojo.test.scenarios.component.SubMarker;

public class Annotation
extends OSGiTestCase {
    private Class clazz;

    public void setUp() {
        try {
            this.clazz = this.getContext().getBundle().loadClass("org.apache.felix.ipojo.test.scenarios.component.Annotation");
        }
        catch (ClassNotFoundException e) {
            Annotation.fail((String)("Cannot load the annotation class : " + e.getMessage()));
        }
    }

    public void testAnnotationOnMethod() {
        Method method = null;
        try {
            method = this.clazz.getMethod("doSomething", new Class[0]);
        }
        catch (Exception e) {
            Annotation.fail((String)("Cannot find the doSomething method : " + e.getMessage()));
        }
        Annotation.assertNotNull((String)"Check method existence", (Object)method);
        java.lang.annotation.Annotation[] annotations = method.getDeclaredAnnotations();
        Annotation.assertNotNull((String)"Check annotations size - 1", (Object)annotations);
        Annotation.assertEquals((String)"Check annotations size - 2", (int)2, (int)annotations.length);
        Marker marker = this.getMarkerAnnotation(annotations);
        Annotation.assertNotNull((String)"Check marker", (Object)marker);
        Annotation.assertEquals((String)"Check marker name", (String)"marker", (String)marker.name());
        Annotation.assertEquals((String)"Check marker type", (Object)((Object)Marker.Type.BAR), (Object)((Object)marker.type()));
        Annotation.assertEquals((String)"Check sub marker attribute", (String)"foo", (String)marker.sub().subname());
        Annotation.assertEquals((String)"Check objects [0]", (String)"foo", (String)marker.arrayOfObjects()[0]);
        Annotation.assertEquals((String)"Check objects [1]", (String)"bar", (String)marker.arrayOfObjects()[1]);
        Annotation.assertEquals((String)"Check objects [2]", (String)"baz", (String)marker.arrayOfObjects()[2]);
        Annotation.assertEquals((String)"Check annotations[0]", (String)"foo", (String)marker.arrayOfAnnotations()[0].subname());
        SubMarker sub = this.getSubMarkerAnnotation(annotations);
        Annotation.assertNotNull((String)"Check submarker", (Object)sub);
        Annotation.assertEquals((String)"Check submarker", (String)"bar", (String)sub.subname());
    }

    public void testAnnotationOnConstructor() {
        Constructor method = null;
        try {
            method = this.clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            Annotation.fail((String)("Cannot find the constructor method : " + e.getMessage()));
        }
        Annotation.assertNotNull((String)"Check method existence", method);
        java.lang.annotation.Annotation[] annotations = method.getDeclaredAnnotations();
        Annotation.assertNotNull((String)"Check annotations size - 1", (Object)annotations);
        Annotation.assertEquals((String)"Check annotations size - 2", (int)2, (int)annotations.length);
        Marker marker = this.getMarkerAnnotation(annotations);
        Annotation.assertNotNull((String)"Check marker", (Object)marker);
        Annotation.assertEquals((String)"Check marker name", (String)"marker", (String)marker.name());
        Annotation.assertEquals((String)"Check marker type", (Object)((Object)Marker.Type.BAR), (Object)((Object)marker.type()));
        Annotation.assertEquals((String)"Check sub marker attribute", (String)"foo", (String)marker.sub().subname());
        Annotation.assertEquals((String)"Check objects [0]", (String)"foo", (String)marker.arrayOfObjects()[0]);
        Annotation.assertEquals((String)"Check objects [1]", (String)"bar", (String)marker.arrayOfObjects()[1]);
        Annotation.assertEquals((String)"Check objects [2]", (String)"baz", (String)marker.arrayOfObjects()[2]);
        Annotation.assertEquals((String)"Check annotations[0]", (String)"foo", (String)marker.arrayOfAnnotations()[0].subname());
        SubMarker sub = this.getSubMarkerAnnotation(annotations);
        Annotation.assertNotNull((String)"Check submarker", (Object)sub);
        Annotation.assertEquals((String)"Check submarker", (String)"bar", (String)sub.subname());
    }

    public void testParameterAnnotations() {
        Method method = null;
        try {
            method = this.clazz.getMethod("doSomethingWithParams", String.class, String.class, String.class);
        }
        catch (Exception e) {
            Annotation.fail((String)("Cannot find the doSomethingWithParams method : " + e.getMessage()));
        }
        Annotation.assertNotNull((String)"Check method existence", method);
        java.lang.annotation.Annotation[][] annotations = method.getParameterAnnotations();
        Annotation.assertNotNull((String)"Check annotations size - 1", (Object)annotations);
        Annotation.assertEquals((String)"Check annotations size - 3", (int)3, (int)annotations.length);
        java.lang.annotation.Annotation[] fooAnns = annotations[0];
        Annotation.assertEquals((String)"Check fooAnns length", (int)1, (int)fooAnns.length);
        Marker marker = (Marker)fooAnns[0];
        Annotation.assertNotNull((String)"Check marker", (Object)marker);
        Annotation.assertEquals((String)"Check marker name", (String)"marker", (String)marker.name());
        Annotation.assertEquals((String)"Check marker type", (Object)((Object)Marker.Type.BAR), (Object)((Object)marker.type()));
        Annotation.assertEquals((String)"Check sub marker attribute", (String)"foo", (String)marker.sub().subname());
        Annotation.assertEquals((String)"Check objects [0]", (String)"foo", (String)marker.arrayOfObjects()[0]);
        Annotation.assertEquals((String)"Check objects [1]", (String)"bar", (String)marker.arrayOfObjects()[1]);
        Annotation.assertEquals((String)"Check objects [2]", (String)"baz", (String)marker.arrayOfObjects()[2]);
        Annotation.assertEquals((String)"Check annotations[0]", (String)"foo", (String)marker.arrayOfAnnotations()[0].subname());
        java.lang.annotation.Annotation[] barAnns = annotations[1];
        Annotation.assertEquals((String)"Check barAnns length", (int)0, (int)barAnns.length);
        Object[] bazAnns = annotations[2];
        System.out.println(Arrays.toString(bazAnns));
        Annotation.assertEquals((String)"Check bazAnns length", (int)2, (int)bazAnns.length);
    }

    private Marker getMarkerAnnotation(java.lang.annotation.Annotation[] annotations) {
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i].annotationType().getName().equals("org.apache.felix.ipojo.test.scenarios.component.Marker")) {
                return (Marker)annotations[i];
            }
            ++i;
        }
        return null;
    }

    private SubMarker getSubMarkerAnnotation(java.lang.annotation.Annotation[] annotations) {
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i].annotationType().getName().equals("org.apache.felix.ipojo.test.scenarios.component.SubMarker")) {
                return (SubMarker)annotations[i];
            }
            ++i;
        }
        return null;
    }
}

