/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.scriptconsole.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class ScriptHelper {
    private final BundleContext bundleContext;
    private List<ServiceReference> references;
    private Map<String, Object> services;

    public ScriptHelper(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public <ServiceType> ServiceType getService(Class<ServiceType> type) {
        ServiceReference ref;
        Object service;
        Object object = service = this.services == null ? null : this.services.get(type.getName());
        if (service == null && (ref = this.bundleContext.getServiceReference(type.getName())) != null && (service = this.bundleContext.getService(ref)) != null) {
            if (this.services == null) {
                this.services = new HashMap<String, Object>();
            }
            if (this.references == null) {
                this.references = new ArrayList<ServiceReference>();
            }
            this.references.add(ref);
            this.services.put(type.getName(), service);
        }
        return (ServiceType)service;
    }

    public <ServiceType> ServiceType[] getServices(Class<ServiceType> serviceType, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs = this.bundleContext.getServiceReferences(serviceType.getName(), filter);
        Object[] result = null;
        if (refs != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i = 0; i < refs.length; ++i) {
                Object service = this.bundleContext.getService(refs[i]);
                if (service == null) continue;
                if (this.references == null) {
                    this.references = new ArrayList<ServiceReference>();
                }
                this.references.add(refs[i]);
                objects.add(service);
            }
            if (objects.size() > 0) {
                Object[] srv = (Object[])Array.newInstance(serviceType, objects.size());
                result = objects.toArray(srv);
            }
        }
        return result;
    }

    public void cleanup() {
        if (this.references != null) {
            for (ServiceReference ref : this.references) {
                this.bundleContext.ungetService(ref);
            }
            this.references.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }
}

