/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.CompressionLevel;
import flash.swf.RandomAccessBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class SwfEncoder
extends RandomAccessBuffer {
    private int bitPos = 8;
    private byte currentByte = 0;
    private int compressPos = -1;
    public int bytesWritten = 0;
    final int swfVersion;

    public SwfEncoder(int version) {
        this.swfVersion = version;
    }

    public void writeUI8(int c) {
        if (this.bitPos != 8 || c < 0 || c > 255) {
            assert (this.bitPos == 8);
            assert (c >= 0 && c <= 255) : "UI8 overflow " + Integer.toHexString(c);
        }
        super.write(c);
    }

    public void writeFixed8(float v) {
        int f8 = (int)(v * 256.0f) & 0xFFFF;
        this.writeUI16(f8);
    }

    public void writeUI16(int c) {
        if (c == -1) {
            c = 65535;
        }
        assert (this.bitPos == 8);
        assert (c >= 0 && c <= 65535) : "UI16 overflow";
        super.write(c);
        super.write(c >> 8);
    }

    public void writeSI16(int c) {
        assert (this.bitPos == 8);
        assert (c >= Short.MIN_VALUE && c <= Short.MAX_VALUE) : "SI16 overflow";
        super.write(c);
        super.write(c >> 8);
    }

    public void write32(int c) {
        assert (this.bitPos == 8);
        super.write(c);
        super.write(c >> 8);
        super.write(c >> 16);
        super.write(c >> 24);
    }

    public void write64(long c) {
        this.write32((int)c);
        this.write32((int)(c >> 32));
    }

    public void writeFloat(float f) {
        int i = Float.floatToIntBits(f);
        this.write32(i);
    }

    public void markComp() {
        this.compressPos = this.getPos();
    }

    public void compress(CompressionLevel compressionLevel) throws IOException {
        if (this.compressPos != -1) {
            this.pos = this.compressPos;
            this.deflate(this, compressionLevel);
            this.compressPos = -1;
        }
    }

    private int deflate(OutputStream out, CompressionLevel compressionLevel) throws IOException {
        int compression = compressionLevel == CompressionLevel.BestSpeed ? 1 : 9;
        Deflater deflater = new Deflater(compression);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream(out, deflater);
        deflaterStream.write(this.buf, this.compressPos, this.count - this.compressPos);
        deflaterStream.finish();
        int bytes = this.compressPos + deflater.getTotalOut();
        deflater.end();
        return bytes;
    }

    public synchronized void writeTo(OutputStream out, CompressionLevel compressionLevel) throws IOException {
        if (this.compressPos == -1) {
            super.writeTo(out);
            this.bytesWritten = this.buf.length;
        } else {
            this.count = this.pos;
            out.write(this.buf, 0, this.compressPos);
            this.bytesWritten = this.deflate(out, compressionLevel);
        }
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void writeBit(boolean data) {
        this.writeBits(data ? 1 : 0, 1);
    }

    private void writeBits(int data, int size) {
        while (size > 0) {
            if (size > this.bitPos) {
                this.currentByte = (byte)(this.currentByte | data << 32 - size >>> 32 - this.bitPos);
                super.write(this.currentByte);
                size -= this.bitPos;
                this.currentByte = 0;
                this.bitPos = 8;
                continue;
            }
            this.currentByte = (byte)(this.currentByte | data << 32 - size >>> 32 - this.bitPos);
            this.bitPos -= size;
            size = 0;
            if (this.bitPos != 0) continue;
            super.write(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    public void writeUBits(int data, int size) {
        assert (data >= 0 && data <= (1 << size) - 1);
        this.writeBits(data, size);
    }

    public void writeSBits(int data, int size) {
        assert (data >= -(1 << size - 1) && data <= (1 << size - 1) - 1);
        this.writeBits(data, size);
    }

    public void flushBits() {
        if (this.bitPos != 8) {
            super.write(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    public synchronized void reset() {
        super.reset();
        this.compressPos = -1;
    }

    public void writeUI8at(int pos, int value) {
        int oldPos = this.getPos();
        this.setPos(pos);
        this.writeUI8(value);
        this.setPos(oldPos);
    }

    public void writeUI16at(int pos, int value) {
        int oldPos = this.getPos();
        this.setPos(pos);
        this.writeUI16(value);
        this.setPos(oldPos);
    }

    public void writeSI16at(int pos, int value) {
        int oldPos = this.getPos();
        this.setPos(pos);
        this.writeSI16(value);
        this.setPos(oldPos);
    }

    public void write32at(int pos, int value) {
        int oldPos = this.getPos();
        this.setPos(pos);
        this.write32(value);
        this.setPos(oldPos);
    }

    public void writeString(String s) {
        block3: {
            try {
                assert (this.bitPos == 8);
                this.write(this.swfVersion >= 6 ? s.getBytes("UTF8") : s.getBytes());
                this.write(0);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void writeLengthString(String name) {
        block3: {
            try {
                assert (this.bitPos == 8);
                byte[] b = this.swfVersion >= 6 ? name.getBytes("UTF8") : name.getBytes();
                super.write(b.length + 1);
                this.write(b);
                this.write(0);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public static int maxNum(int a, int b, int c, int d) {
        a = Math.abs(a);
        b = Math.abs(b);
        c = Math.abs(c);
        d = Math.abs(d);
        return a > b ? (a > c ? (a > d ? a : d) : (c > d ? c : d)) : (b > c ? (b > d ? b : d) : (c > d ? c : d));
    }

    public static int minBits(int number, int bits) {
        int val = 1;
        int x = 1;
        while (val <= number && bits <= 32) {
            val |= x;
            ++bits;
            x <<= 1;
        }
        if (bits > 32) assert (false) : "minBits " + bits + " must not exceed 32";
        return bits;
    }

    public void writeAt(int offset, byte[] b) {
        int oldPos = this.getPos();
        this.setPos(offset);
        this.write(b);
        this.setPos(oldPos);
    }
}

