/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogStore;

@PublicEvolving
public class EnvironmentSettings {
    private final Configuration configuration;
    private final ClassLoader classLoader;
    @Nullable
    private final CatalogStore catalogStore;

    private EnvironmentSettings(Configuration configuration, ClassLoader classLoader) {
        this(configuration, classLoader, null);
    }

    private EnvironmentSettings(Configuration configuration, ClassLoader classLoader, CatalogStore catalogStore) {
        this.configuration = configuration;
        this.classLoader = classLoader;
        this.catalogStore = catalogStore;
    }

    public static EnvironmentSettings inStreamingMode() {
        return EnvironmentSettings.newInstance().inStreamingMode().build();
    }

    public static EnvironmentSettings inBatchMode() {
        return EnvironmentSettings.newInstance().inBatchMode().build();
    }

    public static Builder newInstance() {
        return new Builder();
    }

    @Deprecated
    public static EnvironmentSettings fromConfiguration(ReadableConfig configuration) {
        return new EnvironmentSettings((Configuration)configuration, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public Configuration toConfiguration() {
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getBuiltInCatalogName() {
        return (String)this.configuration.get(TableConfigOptions.TABLE_CATALOG_NAME);
    }

    public String getBuiltInDatabaseName() {
        return (String)this.configuration.get(TableConfigOptions.TABLE_DATABASE_NAME);
    }

    public boolean isStreamingMode() {
        return this.configuration.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
    }

    @Internal
    public ClassLoader getUserClassLoader() {
        return this.classLoader;
    }

    @Nullable
    @Internal
    public CatalogStore getCatalogStore() {
        return this.catalogStore;
    }

    @PublicEvolving
    public static class Builder {
        private final Configuration configuration = new Configuration();
        private ClassLoader classLoader;
        @Nullable
        private CatalogStore catalogStore;

        public Builder inBatchMode() {
            this.configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
            return this;
        }

        public Builder inStreamingMode() {
            this.configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.configuration.set(TableConfigOptions.TABLE_CATALOG_NAME, (Object)builtInCatalogName);
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.configuration.set(TableConfigOptions.TABLE_DATABASE_NAME, (Object)builtInDatabaseName);
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration.addAll(configuration);
            return this;
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withCatalogStore(CatalogStore catalogStore) {
            this.catalogStore = catalogStore;
            return this;
        }

        public EnvironmentSettings build() {
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            return new EnvironmentSettings(this.configuration, this.classLoader, this.catalogStore);
        }
    }
}

