/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.streaming.api.operators.AbstractInput;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.ProcessTableRunner;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.process.AbstractProcessTableOperator;
import org.apache.flink.table.runtime.operators.process.RuntimeChangelogMode;
import org.apache.flink.table.runtime.operators.process.RuntimeStateInfo;
import org.apache.flink.table.runtime.operators.process.RuntimeTableSemantics;

public class ProcessSetTableOperator
extends AbstractProcessTableOperator
implements MultipleInputStreamOperator<RowData> {
    public ProcessSetTableOperator(StreamOperatorParameters<RowData> parameters, List<RuntimeTableSemantics> tableSemantics, List<RuntimeStateInfo> stateInfos, ProcessTableRunner processTableRunner, HashFunction[] stateHashCode, RecordEqualiser[] stateEquals, RuntimeChangelogMode producedChangelogMode) {
        super(parameters, tableSemantics, stateInfos, processTableRunner, stateHashCode, stateEquals, producedChangelogMode);
    }

    public List<Input> getInputs() {
        return IntStream.range(0, this.tableSemantics.size()).mapToObj(inputIdx -> {
            TableSemantics inputSemantics = (TableSemantics)this.tableSemantics.get(inputIdx);
            final int timeColumn = inputSemantics.timeColumn();
            return new AbstractInput<RowData, RowData>((AbstractStreamOperatorV2)this, inputIdx + 1){

                public void processElement(StreamRecord<RowData> element) throws Exception {
                    ProcessSetTableOperator.this.processTableRunner.ingestTableEvent(inputIdx, (RowData)element.getValue(), timeColumn);
                    ProcessSetTableOperator.this.processTableRunner.processEval();
                }
            };
        }).collect(Collectors.toList());
    }
}

