/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedProcessTableRunner;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.ProcessTableRunner;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.process.ProcessRowTableOperator;
import org.apache.flink.table.runtime.operators.process.ProcessSetTableOperator;
import org.apache.flink.table.runtime.operators.process.RuntimeChangelogMode;
import org.apache.flink.table.runtime.operators.process.RuntimeStateInfo;
import org.apache.flink.table.runtime.operators.process.RuntimeTableSemantics;

public class ProcessTableOperatorFactory
extends AbstractStreamOperatorFactory<RowData> {
    private static final long serialVersionUID = 1L;
    private final List<RuntimeTableSemantics> tableSemantics;
    private final List<RuntimeStateInfo> stateInfos;
    private final GeneratedProcessTableRunner generatedProcessTableRunner;
    private final GeneratedHashFunction[] generatedStateHashCode;
    private final GeneratedRecordEqualiser[] generatedStateEquals;
    private final RuntimeChangelogMode producedChangelogMode;

    public ProcessTableOperatorFactory(List<RuntimeTableSemantics> tableSemantics, List<RuntimeStateInfo> stateInfos, GeneratedProcessTableRunner generatedProcessTableRunner, GeneratedHashFunction[] generatedStateHashCode, GeneratedRecordEqualiser[] generatedStateEquals, RuntimeChangelogMode producedChangelogMode) {
        this.tableSemantics = tableSemantics;
        this.stateInfos = stateInfos;
        this.generatedProcessTableRunner = generatedProcessTableRunner;
        this.generatedStateHashCode = generatedStateHashCode;
        this.generatedStateEquals = generatedStateEquals;
        this.producedChangelogMode = producedChangelogMode;
    }

    public StreamOperator createStreamOperator(StreamOperatorParameters parameters) {
        ClassLoader classLoader = parameters.getContainingTask().getUserCodeClassLoader();
        ProcessTableRunner runner = (ProcessTableRunner)((Object)this.generatedProcessTableRunner.newInstance(classLoader));
        HashFunction[] stateHashCode = (HashFunction[])Arrays.stream(this.generatedStateHashCode).map(g -> (HashFunction)g.newInstance(classLoader)).toArray(HashFunction[]::new);
        RecordEqualiser[] stateEquals = (RecordEqualiser[])Arrays.stream(this.generatedStateEquals).map(g -> (RecordEqualiser)g.newInstance(classLoader)).toArray(RecordEqualiser[]::new);
        if (this.tableSemantics.stream().anyMatch(RuntimeTableSemantics::hasSetSemantics)) {
            return new ProcessSetTableOperator((StreamOperatorParameters<RowData>)parameters, this.tableSemantics, this.stateInfos, runner, stateHashCode, stateEquals, this.producedChangelogMode);
        }
        return new ProcessRowTableOperator((StreamOperatorParameters<RowData>)parameters, this.tableSemantics, this.stateInfos, runner, stateHashCode, stateEquals, this.producedChangelogMode);
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        if (this.tableSemantics.stream().anyMatch(RuntimeTableSemantics::hasSetSemantics)) {
            return ProcessSetTableOperator.class;
        }
        return ProcessRowTableOperator.class;
    }
}

