/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.sink.constraint.ConstraintEnforcerExecutor;
import org.apache.flink.table.runtime.util.StreamRecordCollector;

@Internal
public class ConstraintEnforcer
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final String operatorName;
    private final ConstraintEnforcerExecutor executor;
    private transient StreamRecordCollector<RowData> collector;

    public ConstraintEnforcer(ConstraintEnforcerExecutor executor, String operatorName) {
        this.executor = executor;
        this.operatorName = operatorName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new StreamRecordCollector(this.output);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData processedRowData = this.executor.enforce((RowData)element.getValue());
        if (processedRowData != null) {
            this.collector.collect(processedRowData);
        }
    }
}

