/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class RowTypeUtils {
    public static String getUniqueName(String oldName, List<String> checklist) {
        return RowTypeUtils.getUniqueName(Collections.singletonList(oldName), checklist).get(0);
    }

    public static List<String> getUniqueName(List<String> oldNames, List<String> checklist) {
        ArrayList<String> result = new ArrayList<String>();
        for (String oldName : oldNames) {
            if (checklist.contains(oldName) || result.contains(oldName)) {
                String changedName;
                int suffix = -1;
                while (checklist.contains(changedName = oldName + "_" + ++suffix) || result.contains(changedName)) {
                }
                result.add(changedName);
                continue;
            }
            result.add(oldName);
        }
        return result;
    }

    public static RowType projectRowType(@Nonnull RowType rowType, @Nonnull int[] projection) throws IllegalArgumentException {
        int fieldCnt = rowType.getFieldCount();
        return RowType.of((LogicalType[])Arrays.stream(projection).mapToObj(index -> {
            if (index >= fieldCnt) {
                throw new IllegalArgumentException(String.format("Invalid projection index: %d of source rowType size: %d", index, fieldCnt));
            }
            return rowType.getTypeAt(index);
        }).toArray(LogicalType[]::new), (String[])Arrays.stream(projection).mapToObj(index -> rowType.getFieldNames().get(index)).toArray(String[]::new));
    }
}

