/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.internal.ArrayComparisonFailure;

@Category(value={FilterTests.class, SmallTests.class})
public class TestFuzzyRowFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFuzzyRowFilter.class);

    @Test
    public void testIdempotentMaskShift() {
        byte[] test = new byte[]{-1, 0, 2};
        byte[] original = Arrays.copyOf(test, test.length);
        byte[] expected = new byte[]{-1, 0, 0};
        Assert.assertArrayEquals((byte[])test, (byte[])original);
        this.assertArrayNotEquals(expected, test);
        FuzzyRowFilter.idempotentMaskShift((byte[])test);
        Assert.assertArrayEquals((byte[])expected, (byte[])test);
        this.assertArrayNotEquals(original, test);
        FuzzyRowFilter.idempotentMaskShift((byte[])test);
        Assert.assertArrayEquals((byte[])expected, (byte[])test);
        this.assertArrayNotEquals(original, test);
    }

    private void assertArrayNotEquals(byte[] expected, byte[] testcase) {
        try {
            Assert.assertArrayEquals((byte[])expected, (byte[])testcase);
            Assert.fail((String)"expected arrays to fail equality test");
        }
        catch (ArrayComparisonFailure arrayComparisonFailure) {
            // empty catch block
        }
    }

    @Test
    public void testSatisfiesNoUnsafeForward() {
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, -128, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, -128, 2, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 2, 1, 3, 3}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, -11, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 2, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{1, 0, 0}));
    }

    @Test
    public void testSatisfiesForward() {
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, -128, 1, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, -128, 2, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, 2, 1, 3, 3}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, -11, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)false, (byte[])new byte[]{1, 2, 1, 0, 1}, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{0, -1, -1}));
    }

    @Test
    public void testSatisfiesReverse() {
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, -128, 1, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, -128, 2, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, 2, 1, 3, 3}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfies((boolean)true, (byte[])new byte[]{1, 2, 1, 0, 1}, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{0, -1, -1}));
    }

    @Test
    public void testSatisfiesNoUnsafeReverse() {
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -128, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -128, 2, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{2, 3, 1, 1, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.YES, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 2, 1, 3, 3}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -11, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 3, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{2, 1, 1, 1, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilter.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 2, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{1, 0, 0}));
    }

    @Test
    public void testGetNextForFuzzyRuleForward() {
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{2, 1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 1, 2, 0, 1}, new byte[]{1, 1, 2, 0, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 0, 2, 0, 1}, new byte[]{1, 1, 0, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -127, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{5, 1, 1, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1, 1}, new byte[]{5, 1, 0, 1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 1}, new byte[]{6, 1, 0, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -1, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 4});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{0, 1, 3, 2}, new byte[]{1, 1});
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
    }

    @Test
    public void testGetNextForFuzzyRuleReverse() {
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{1, 1, 3});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 2, 1, 3, 1}, new byte[]{1, 1, -1, 3});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -128, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2, 1}, new byte[]{5, 1, 0, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{4, 1, -1, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -2, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{2, 1, 3, 2}, new byte[]{1, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{2, 3, 1, 1, 1}, new byte[]{1, -1, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, -11, 1, 3, 0}, new byte[]{1, 1, -1, 4});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, 3, 1, 3, 0}, new byte[]{1, 2, -1, 4});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{2, 1, 1, 1, 0}, new byte[]{1, 2, -1, 4});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2}, new byte[]{1, -128, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2}, new byte[]{5, 1, 0, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 2});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 3});
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule((boolean)true, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
    }

    private static void assertNext(boolean reverse, byte[] fuzzyRow, byte[] mask, byte[] current, byte[] expected) {
        KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])current);
        byte[] nextForFuzzyRule = FuzzyRowFilter.getNextForFuzzyRule((boolean)reverse, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])fuzzyRow, (byte[])mask);
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])expected), (Object)Bytes.toStringBinary((byte[])nextForFuzzyRule));
    }
}

