/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestRandomRowFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRandomRowFilter.class);
    protected RandomRowFilter quarterChanceFilter;

    @Before
    public void setUp() throws Exception {
        this.quarterChanceFilter = new RandomRowFilter(0.25f);
    }

    @Test
    public void testBasics() throws Exception {
        int included = 0;
        int max = 1000000;
        for (int i = 0; i < max; ++i) {
            if (this.quarterChanceFilter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"row")))) continue;
            ++included;
        }
        int epsilon = max / 100;
        Assert.assertTrue((String)"Roughly 25% should pass the filter", (Math.abs(included - max / 4) < epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() throws Exception {
        RandomRowFilter newFilter = this.serializationTest(this.quarterChanceFilter);
        Assert.assertTrue((String)"float should be equal", (Math.abs(newFilter.getChance() - this.quarterChanceFilter.getChance()) < 1.0E-6f ? 1 : 0) != 0);
    }

    private RandomRowFilter serializationTest(RandomRowFilter filter) throws Exception {
        byte[] buffer = filter.toByteArray();
        RandomRowFilter newFilter = RandomRowFilter.parseFrom((byte[])buffer);
        return newFilter;
    }
}

