/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, MasterTests.class})
public class TestAlwaysStandByHMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAlwaysStandByHMaster.class);
    private static final StartMiniClusterOption OPTION = StartMiniClusterOption.builder().numAlwaysStandByMasters(1).numMasters(1).numRegionServers(1).build();
    @ClassRule
    public static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(OPTION).build();

    @Test
    public void testAlwaysStandBy() throws Exception {
        HBaseTestingUtility testUtil = miniClusterRule.getTestingUtility();
        Assert.assertNotNull((Object)testUtil.getMiniHBaseCluster().getMaster());
        Assert.assertEquals((long)2L, (long)testUtil.getMiniHBaseCluster().getMasterThreads().size());
        testUtil.getMiniHBaseCluster().stopMaster(0).join();
        Assert.assertFalse((boolean)testUtil.getMiniHBaseCluster().waitForActiveAndReadyMaster(5000L));
        HMaster newActive = testUtil.getMiniHBaseCluster().startMaster().getMaster();
        TestCase.assertTrue((boolean)testUtil.getMiniHBaseCluster().waitForActiveAndReadyMaster(5000L));
        Assert.assertEquals((Object)newActive.getServerName(), (Object)testUtil.getMiniHBaseCluster().getMaster().getServerName());
    }
}

