/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTableStateManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableStateManager.class);
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws Exception {
        this.TEST_UTIL.startMiniCluster();
    }

    @After
    public void after() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMigration() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.createTable(tableName, "info");
        this.TEST_UTIL.getAdmin().disableTable(tableName);
        TableState state = MetaTableAccessor.getTableState((Connection)this.TEST_UTIL.getConnection(), (TableName)tableName);
        TestCase.assertTrue((String)("State=" + state), (boolean)state.getState().equals((Object)TableState.State.DISABLED));
        MetaTableAccessor.deleteTableState((Connection)this.TEST_UTIL.getConnection(), (TableName)tableName);
        TestCase.assertTrue((MetaTableAccessor.getTableState((Connection)this.TEST_UTIL.getConnection(), (TableName)tableName) == null ? 1 : 0) != 0);
        HMaster master = this.TEST_UTIL.getMiniHBaseCluster().getMaster();
        master.stop("Restarting");
        while (!master.isStopped()) {
            Threads.sleep((long)1L);
        }
        TestCase.assertTrue((boolean)master.isStopped());
        JVMClusterUtil.MasterThread newMasterThread = this.TEST_UTIL.getMiniHBaseCluster().startMaster();
        master = newMasterThread.getMaster();
        while (!master.isInitialized()) {
            Threads.sleep((long)1L);
        }
        TestCase.assertTrue((boolean)MetaTableAccessor.getTableState((Connection)this.TEST_UTIL.getConnection(), (TableName)tableName).getState().equals((Object)TableState.State.DISABLED));
    }
}

