/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperStub;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsTableMetricsMap {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsTableMetricsMap.class);
    private String tableName = "testTableMetricsMap";
    private MetricsTableWrapperStub tableWrapper;
    private MetricsTable mt;
    private MetricsRegionServerWrapper rsWrapper;
    private MetricsRegionServer rsm;
    private MetricsTableAggregateSourceImpl agg;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        this.tableWrapper = new MetricsTableWrapperStub(this.tableName);
        this.mt = new MetricsTable((MetricsTableWrapperAggregate)this.tableWrapper);
        this.rsWrapper = new MetricsRegionServerWrapperStub();
        this.rsm = new MetricsRegionServer(this.rsWrapper, conf, this.mt);
        MetricsTableAggregateSource tableSourceAgg = this.mt.getTableSourceAgg();
        if (!(tableSourceAgg instanceof MetricsTableAggregateSourceImpl)) {
            throw new RuntimeException("tableSourceAgg should be the instance of MetricsTableAggregateSourceImpl");
        }
        this.agg = (MetricsTableAggregateSourceImpl)tableSourceAgg;
    }

    @Test
    public void testMetricsMap() throws InterruptedException {
        this.rsm.updateCompaction(this.tableName, true, 100L, 200, 300, 400L, 500L);
        int metricsMapSize = this.agg.getMetricsRegistry().getMetricsMap().size();
        Assert.assertTrue((String)"table metrics added then metricsMapSize should larger than 0", (metricsMapSize > 0 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.agg.deleteTableSource(this.tableName);
        metricsMapSize = this.agg.getMetricsRegistry().getMetricsMap().size();
        Assert.assertEquals((String)"table metrics all deleted then metricsSize should be 0", (long)0L, (long)metricsMapSize);
    }
}

