/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.AbstractSaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.BuiltInProviderSelector;
import org.apache.hadoop.hbase.security.provider.SaslAuthMethod;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomSaslAuthenticationProviderTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(CustomSaslAuthenticationProviderTestBase.class);
    private static final Map<String, String> USER_DATABASE = CustomSaslAuthenticationProviderTestBase.createUserDatabase();
    private static final String USER1_PASSWORD = "foobarbaz";
    private static final String USER2_PASSWORD = "bazbarfoo";
    @Parameterized.Parameter
    public String rpcClientImpl;
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Configuration CONF = UTIL.getConfiguration();
    private static LocalHBaseCluster CLUSTER;
    private static File KEYTAB_FILE;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();
    private TableName tableName;
    private String clusterId;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({BlockingRpcClient.class.getName()}, {NettyRpcClient.class.getName()});
    }

    private static Map<String, String> createUserDatabase() {
        ConcurrentHashMap<String, String> db = new ConcurrentHashMap<String, String>();
        db.put("user1", USER1_PASSWORD);
        db.put("user2", USER2_PASSWORD);
        return db;
    }

    public static String getPassword(String user) {
        String password = USER_DATABASE.get(user);
        if (password == null) {
            throw new IllegalStateException("Cannot request password for a user that doesn't exist");
        }
        return password;
    }

    public static Token<? extends TokenIdentifier> createPasswordToken(String username, String password, String clusterId) {
        PasswordAuthTokenIdentifier id = new PasswordAuthTokenIdentifier(username);
        Token token = new Token(id.getBytes(), Bytes.toBytes((String)password), id.getKind(), new Text(clusterId));
        return token;
    }

    private static void createBaseCluster(HBaseTestingUtility util, File keytabFile, MiniKdc kdc) throws Exception {
        String servicePrincipal = "hbase/localhost";
        String spnegoPrincipal = "HTTP/localhost";
        kdc.createPrincipal(keytabFile, new String[]{servicePrincipal});
        util.startMiniZKCluster();
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)util.getConfiguration(), (String)(servicePrincipal + "@" + kdc.getRealm()), (String)(spnegoPrincipal + "@" + kdc.getRealm()));
        HBaseKerberosUtils.setSSLConfiguration((HBaseCommonTestingUtility)util, SecureTestCluster.class);
        util.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{TokenProvider.class.getName()});
        util.startMiniDFSCluster(1);
        Path rootdir = util.getDataTestDirOnTestFS("TestCustomSaslAuthenticationProvider");
        CommonFSUtils.setRootDir((Configuration)util.getConfiguration(), (Path)rootdir);
    }

    protected static void startCluster(String rpcServerImpl) throws Exception {
        KEYTAB_FILE = new File(UTIL.getDataTestDir("keytab").toUri().getPath());
        MiniKdc kdc = UTIL.setupMiniKdc(KEYTAB_FILE);
        CONF.setStrings("hbase.client.sasl.provider.extras", new String[]{InMemoryClientProvider.class.getName()});
        CONF.setStrings("hbase.server.sasl.provider.extras", new String[]{InMemoryServerProvider.class.getName()});
        CONF.set("hbase.client.sasl.provider.class", InMemoryProviderSelector.class.getName());
        CONF.setLong("hadoop.kerberos.min.seconds.before.relogin", 600L);
        CustomSaslAuthenticationProviderTestBase.createBaseCluster(UTIL, KEYTAB_FILE, kdc);
        CONF.set("hbase.rpc.server.impl", rpcServerImpl);
        CLUSTER = new LocalHBaseCluster(CONF, 1);
        CLUSTER.startup();
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        if (CLUSTER != null) {
            CLUSTER.shutdown();
            CLUSTER = null;
        }
        UTIL.shutdownMiniDFSCluster();
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws Exception {
        this.createTable();
    }

    @After
    public void tearDown() throws IOException {
        UTIL.deleteTable(this.name.getTableName());
    }

    private void createTable() throws Exception {
        this.tableName = this.name.getTableName();
        UserGroupInformation serviceUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"hbase/localhost", (String)KEYTAB_FILE.getAbsolutePath());
        this.clusterId = (String)serviceUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            /*
             * Exception decompiling
             */
            @Override
            public String run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        Assert.assertNotNull((Object)this.clusterId);
    }

    private Configuration getClientConf() {
        Configuration conf = new Configuration(CONF);
        conf.set("hbase.rpc.client.impl", this.rpcClientImpl);
        return conf;
    }

    @Test
    public void testPositiveAuthentication() throws Exception {
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[0]);
        user1.addToken(CustomSaslAuthenticationProviderTestBase.createPasswordToken("user1", USER1_PASSWORD, this.clusterId));
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * Exception decompiling
             */
            @Override
            public Void run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    @Test
    public void testNegativeAuthentication() throws Exception {
        final Configuration clientConf = new Configuration(CONF);
        clientConf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        clientConf.setInt("hbase.client.retries.number", 3);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[0]);
        user1.addToken(CustomSaslAuthenticationProviderTestBase.createPasswordToken("user1", "definitely not the password", this.clusterId));
        user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)clientConf);
                     Table t = conn.getTable(CustomSaslAuthenticationProviderTestBase.this.tableName);){
                    t.get(new Get(Bytes.toBytes((String)"r1")));
                    Assert.fail((String)"Should not successfully authenticate with HBase");
                }
                catch (RetriesExhaustedException re) {
                    Assert.assertTrue((String)re.getMessage(), (boolean)re.getMessage().contains("SaslException"));
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception caught, was expecting a authentication error: " + Throwables.getStackTraceAsString((Throwable)e)));
                }
                return null;
            }
        });
    }

    static /* synthetic */ Configuration access$200() {
        return CONF;
    }

    static /* synthetic */ HBaseTestingUtility access$400() {
        return UTIL;
    }

    static /* synthetic */ Configuration access$500(CustomSaslAuthenticationProviderTestBase x0) {
        return x0.getClientConf();
    }

    public static class InMemoryProviderSelector
    extends BuiltInProviderSelector {
        private InMemoryClientProvider inMemoryProvider;

        public void configure(Configuration conf, Collection<SaslClientAuthenticationProvider> providers) {
            super.configure(conf, providers);
            Optional<SaslClientAuthenticationProvider> o = providers.stream().filter(p -> p instanceof InMemoryClientProvider).findAny();
            this.inMemoryProvider = (InMemoryClientProvider)o.orElseThrow(() -> new RuntimeException("InMemoryClientProvider not found in available providers: " + providers));
        }

        public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> selectProvider(String clusterId, User user) {
            Pair superPair = super.selectProvider(clusterId, user);
            Optional<Token<? extends TokenIdentifier>> optional = this.inMemoryProvider.findToken(user);
            if (optional.isPresent()) {
                LOG.info("Using InMemoryClientProvider");
                return new Pair((Object)this.inMemoryProvider, optional.get());
            }
            LOG.info("InMemoryClientProvider not usable, falling back to {}", (Object)superPair);
            return superPair;
        }
    }

    public static class InMemoryServerProvider
    extends InMemoryClientProvider
    implements SaslServerAuthenticationProvider {
        public AttemptingUserProvidingSaslServer createServer(SecretManager<TokenIdentifier> secretManager, Map<String, String> saslProps) throws IOException {
            return new AttemptingUserProvidingSaslServer(Sasl.createSaslServer(this.getSaslAuthMethod().getSaslMechanism(), null, "default", saslProps, new InMemoryServerProviderCallbackHandler()), () -> null);
        }

        public boolean supportsProtocolAuthentication() {
            return false;
        }

        public UserGroupInformation getAuthorizedUgi(String authzId, SecretManager<TokenIdentifier> secretManager) throws IOException {
            byte[] encodedId = SaslUtil.decodeIdentifier((String)authzId);
            PasswordAuthTokenIdentifier tokenId = new PasswordAuthTokenIdentifier();
            try {
                tokenId.readFields(new DataInputStream(new ByteArrayInputStream(encodedId)));
            }
            catch (IOException e) {
                throw new IOException("Can't de-serialize PasswordAuthTokenIdentifier", e);
            }
            UserGroupInformation authorizedUgi = tokenId.getUser();
            if (authorizedUgi == null) {
                throw new AccessDeniedException("Can't retrieve username from tokenIdentifier.");
            }
            authorizedUgi.addTokenIdentifier((TokenIdentifier)tokenId);
            authorizedUgi.setAuthenticationMethod(this.getSaslAuthMethod().getAuthMethod());
            return authorizedUgi;
        }

        private class InMemoryServerProviderCallbackHandler
        implements CallbackHandler {
            private InMemoryServerProviderCallbackHandler() {
            }

            @Override
            public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof AuthorizeCallback) {
                        ac = (AuthorizeCallback)callback;
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) continue;
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL Callback");
                }
                if (nc != null && pc != null) {
                    byte[] encodedId = SaslUtil.decodeIdentifier((String)nc.getDefaultName());
                    PasswordAuthTokenIdentifier id = new PasswordAuthTokenIdentifier();
                    try {
                        id.readFields(new DataInputStream(new ByteArrayInputStream(encodedId)));
                    }
                    catch (IOException e) {
                        throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
                    }
                    char[] actualPassword = SaslUtil.encodePassword((byte[])Bytes.toBytes((String)CustomSaslAuthenticationProviderTestBase.getPassword(id.getUser().getUserName())));
                    pc.setPassword(actualPassword);
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (ac.isAuthorized()) {
                        ac.setAuthorizedID(authzid);
                    }
                }
            }
        }
    }

    public static class InMemoryClientProvider
    extends AbstractSaslClientAuthenticationProvider {
        public static final String MECHANISM = "DIGEST-MD5";
        public static final SaslAuthMethod SASL_AUTH_METHOD = new SaslAuthMethod("IN_MEMORY", 42, "DIGEST-MD5", UserGroupInformation.AuthenticationMethod.TOKEN);

        public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
            return Sasl.createSaslClient(new String[]{MECHANISM}, null, null, "default", saslProps, new InMemoryClientProviderCallbackHandler(token));
        }

        public Optional<Token<? extends TokenIdentifier>> findToken(User user) {
            List tokens = user.getTokens().stream().filter(token -> token.getKind().equals((Object)PasswordAuthTokenIdentifier.PASSWORD_AUTH_TOKEN)).collect(Collectors.toList());
            if (tokens.isEmpty()) {
                return Optional.empty();
            }
            if (tokens.size() > 1) {
                throw new IllegalStateException("Cannot handle more than one PasswordAuthToken");
            }
            return Optional.of(tokens.get(0));
        }

        public SaslAuthMethod getSaslAuthMethod() {
            return SASL_AUTH_METHOD;
        }

        public RPCProtos.UserInformation getUserInfo(User user) {
            return null;
        }

        public class InMemoryClientProviderCallbackHandler
        implements CallbackHandler {
            private final Token<? extends TokenIdentifier> token;

            public InMemoryClientProviderCallbackHandler(Token<? extends TokenIdentifier> token) {
                this.token = token;
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                TextInputCallback rc = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof RealmChoiceCallback) continue;
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        rc = (RealmCallback)callback;
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
                }
                if (nc != null) {
                    nc.setName(SaslUtil.encodeIdentifier((byte[])this.token.getIdentifier()));
                }
                if (pc != null) {
                    pc.setPassword(SaslUtil.encodePassword((byte[])this.token.getPassword()));
                }
                if (rc != null) {
                    rc.setText(rc.getDefaultText());
                }
            }
        }
    }

    public static class PasswordAuthTokenIdentifier
    extends TokenIdentifier {
        public static final Text PASSWORD_AUTH_TOKEN = new Text("HBASE_PASSWORD_TEST_TOKEN");
        private String username;

        public PasswordAuthTokenIdentifier() {
        }

        public PasswordAuthTokenIdentifier(String username) {
            this.username = username;
        }

        public void readFields(DataInput in) throws IOException {
            this.username = WritableUtils.readString((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeString((DataOutput)out, (String)this.username);
        }

        public Text getKind() {
            return PASSWORD_AUTH_TOKEN;
        }

        public UserGroupInformation getUser() {
            if (this.username == null || "".equals(this.username)) {
                return null;
            }
            return UserGroupInformation.createRemoteUser((String)this.username);
        }
    }
}

