/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerRuntimeContext {
    private final Container container;
    private final Map<Attribute<?>, Object> executionAttributes;

    private ContainerRuntimeContext(Builder builder) {
        this.container = builder.container;
        this.executionAttributes = builder.executionAttributes;
    }

    public Container getContainer() {
        return this.container;
    }

    public Map<Attribute<?>, Object> getExecutionAttributes() {
        return Collections.unmodifiableMap(this.executionAttributes);
    }

    public <E> E getExecutionAttribute(Attribute<E> attribute) {
        return (E)((Attribute)attribute).valueClass.cast(this.executionAttributes.get(attribute));
    }

    public static final class Builder {
        private final Container container;
        private Map<Attribute<?>, Object> executionAttributes = new HashMap();

        public Builder(Container container) {
            this.container = container;
        }

        public <E> Builder setExecutionAttribute(Attribute<E> attribute, E value) {
            this.executionAttributes.put(attribute, ((Attribute)attribute).valueClass.cast(value));
            return this;
        }

        public ContainerRuntimeContext build() {
            return new ContainerRuntimeContext(this);
        }
    }

    public static final class Attribute<T> {
        private final Class<T> valueClass;
        private final String id;

        private Attribute(Class<T> valueClass, String id) {
            this.valueClass = valueClass;
            this.id = id;
        }

        public int hashCode() {
            return this.valueClass.hashCode() + 31 * this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)obj;
            return this.valueClass.equals(attribute.valueClass) && this.id.equals(attribute.id);
        }

        public static <T> Attribute<T> attribute(Class<T> valueClass, String id) {
            return new Attribute<T>(valueClass, id);
        }
    }
}

