/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;

public class ReplicaEventMessageSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private transient SchemaManager schemaManager;

    public ReplicaEventMessageSerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public byte[] serialize(Object object) throws IOException {
        ReplicaEventMessage replicaEventMessage = (ReplicaEventMessage)object;
        Entry entry = replicaEventMessage.getEntry();
        ChangeType changeType = replicaEventMessage.getChangeType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeByte(changeType.getValue());
        entry.getDn().writeExternal((ObjectOutput)out);
        entry.writeExternal((ObjectOutput)out);
        out.flush();
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        ReplicaEventMessage replicaEventMessage = null;
        try {
            byte type = in.readByte();
            ChangeType changeType = ChangeType.getChangeType((int)type);
            Dn entryDn = new Dn(this.schemaManager);
            entryDn.readExternal((ObjectInput)in);
            DefaultEntry entry = new DefaultEntry(this.schemaManager);
            entry.readExternal((ObjectInput)in);
            entry.setDn(entryDn);
            replicaEventMessage = new ReplicaEventMessage(changeType, (Entry)entry);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        return replicaEventMessage;
    }
}

