/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestProcedureRollbackAIOOB {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureRollbackAIOOB.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private WALProcedureStore procStore;
    private ProcedureExecutor<Void> procExec;
    @Rule
    public final TestName name = new TestName();

    @Before
    public void setUp() throws IOException {
        this.procStore = ProcedureTestingUtility.createWalStore(UTIL.getConfiguration(), UTIL.getDataTestDir(this.name.getMethodName()));
        this.procStore.start(2);
        this.procExec = new ProcedureExecutor(UTIL.getConfiguration(), null, (ProcedureStore)this.procStore);
        ProcedureTestingUtility.initAndStartWorkers(this.procExec, 2, true);
    }

    @After
    public void tearDown() {
        this.procExec.stop();
        this.procStore.stop(false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testArrayIndexOutOfBounds() {
        ParentProcedure proc = new ParentProcedure();
        long procId = this.procExec.submitProcedure((Procedure)proc);
        long noopProcId = -1L;
        for (int i = 0; i < 62; ++i) {
            noopProcId = this.procExec.submitProcedure(new ProcedureTestingUtility.NoopProcedure());
        }
        long lastNoopProcId = noopProcId;
        UTIL.waitFor(30000L, () -> this.procExec.isFinished(lastNoopProcId));
        proc.latch.countDown();
        UTIL.waitFor(10000L, () -> this.procExec.isFinished(procId));
    }

    public static final class SubProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        @Override
        protected Procedure[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            this.setFailure("Inject error", new RuntimeException("Inject error"));
            return null;
        }
    }

    public static final class ParentProcedure
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean scheduled;

        @Override
        protected Procedure<Void>[] execute(Void env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            this.latch.await();
            if (this.scheduled) {
                return null;
            }
            this.scheduled = true;
            return new Procedure[]{new SubProcedure()};
        }
    }
}

