/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProtobufDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufDecoder.class);
    private static Class<?> protobufMessageLiteClass = null;
    private static Class<?> protobufMessageLiteBuilderClass = null;
    private static final boolean HAS_PARSER;
    private static Method getParserForTypeMethod;
    private static Method newBuilderForTypeMethod;
    private Method parseFromMethod;
    private Method mergeFromMethod;
    private Method buildMethod;
    private Object parser;
    private Object builder;

    public ProtobufDecoder(Object prototype) {
        try {
            Method getDefaultInstanceForTypeMethod = protobufMessageLiteClass.getMethod("getDefaultInstanceForType", new Class[0]);
            Object prototype1 = getDefaultInstanceForTypeMethod.invoke(ObjectUtil.checkNotNull(prototype, "prototype"), new Object[0]);
            this.parser = getParserForTypeMethod.invoke(prototype1, new Object[0]);
            this.parseFromMethod = this.parser.getClass().getMethod("parseFrom", byte[].class, Integer.TYPE, Integer.TYPE);
            this.builder = newBuilderForTypeMethod.invoke(prototype1, new Object[0]);
            this.mergeFromMethod = this.builder.getClass().getMethod("mergeFrom", byte[].class, Integer.TYPE, Integer.TYPE);
            this.buildMethod = protobufMessageLiteBuilderClass.getDeclaredMethod("build", new Class[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        Object addObj;
        int offset;
        byte[] array;
        int length = msg.readableBytes();
        if (msg.hasArray()) {
            array = msg.array();
            offset = msg.arrayOffset() + msg.readerIndex();
        } else {
            array = ByteBufUtil.getBytes(msg, msg.readerIndex(), length, false);
            offset = 0;
        }
        if (HAS_PARSER) {
            addObj = this.parseFromMethod.invoke(this.parser, array, offset, length);
        } else {
            Object builderObj = this.mergeFromMethod.invoke(this.builder, array, offset, length);
            addObj = this.buildMethod.invoke(builderObj, new Object[0]);
        }
        out.add(addObj);
    }

    static {
        boolean hasParser = false;
        try {
            protobufMessageLiteClass = Class.forName("org.apache.hadoop.thirdparty.protobuf.MessageLite");
            protobufMessageLiteBuilderClass = Class.forName("org.apache.hadoop.thirdparty.protobuf.MessageLite$Builder");
            LOG.debug("Hadoop 3.3 and above shades protobuf.");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Hadoop 3.2 and below use unshaded protobuf.", (Throwable)e);
            try {
                protobufMessageLiteClass = Class.forName("org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageLite");
                protobufMessageLiteBuilderClass = Class.forName("org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageLite$Builder");
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("can not initialize protobuf related classes for hadoop", ex);
            }
        }
        try {
            getParserForTypeMethod = protobufMessageLiteClass.getDeclaredMethod("getParserForType", new Class[0]);
            newBuilderForTypeMethod = protobufMessageLiteClass.getDeclaredMethod("newBuilderForType", new Class[0]);
            hasParser = true;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("can not initialize protobuf related classes for hadoop", e);
        }
        HAS_PARSER = hasParser;
    }
}

