/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractRecoveredEditsOutputSink;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class BoundedRecoveredEditsOutputSink
extends AbstractRecoveredEditsOutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(BoundedRecoveredEditsOutputSink.class);
    private ConcurrentMap<String, Long> regionEditsWrittenMap = new ConcurrentHashMap<String, Long>();
    private final AtomicInteger openingWritersNum = new AtomicInteger(0);

    public BoundedRecoveredEditsOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(walSplitter, controller, entryBuffers, numWriters);
    }

    @Override
    public void append(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
        List<WAL.Entry> entries = buffer.entries;
        if (entries.isEmpty()) {
            LOG.warn("got an empty buffer, skipping");
            return;
        }
        AbstractRecoveredEditsOutputSink.RecoveredEditsWriter writer = this.createRecoveredEditsWriter(buffer.tableName, buffer.encodedRegionName, entries.get(0).getKey().getSequenceId());
        if (writer != null) {
            this.openingWritersNum.incrementAndGet();
            writer.writeRegionEntries(entries);
            this.regionEditsWrittenMap.compute(Bytes.toString(buffer.encodedRegionName), (k, v) -> v == null ? writer.editsWritten : v + writer.editsWritten);
            ArrayList<IOException> thrown = new ArrayList<IOException>();
            Path dst = this.closeRecoveredEditsWriterAndFinalizeEdits(writer, thrown);
            this.splits.add(dst);
            this.openingWritersNum.decrementAndGet();
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException(thrown);
            }
        }
    }

    @Override
    public List<Path> close() throws IOException {
        boolean isSuccessful = true;
        try {
            isSuccessful = this.finishWriterThreads(false);
        }
        finally {
            isSuccessful &= this.writeRemainingEntryBuffers();
        }
        return isSuccessful ? this.splits : null;
    }

    private boolean writeRemainingEntryBuffers() throws IOException {
        for (EntryBuffers.RegionEntryBuffer buffer : this.entryBuffers.buffers.values()) {
            this.closeCompletionService.submit(() -> {
                this.append(buffer);
                return null;
            });
        }
        boolean progressFailed = false;
        try {
            int n = this.entryBuffers.buffers.size();
            for (int i = 0; i < n; ++i) {
                Future future = this.closeCompletionService.take();
                future.get();
                if (progressFailed || this.reporter == null || this.reporter.progress()) continue;
                progressFailed = true;
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(e);
            throw iie;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            this.closeThreadPool.shutdownNow();
        }
        return !progressFailed;
    }

    @Override
    public Map<String, Long> getOutputCounts() {
        return this.regionEditsWrittenMap;
    }

    @Override
    public int getNumberOfRecoveredRegions() {
        return this.regionEditsWrittenMap.size();
    }

    @Override
    public int getNumOpenWriters() {
        return this.openingWritersNum.get();
    }
}

