/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.concurrent.atomic.AtomicLong;

class BTreeHeader {
    private AtomicLong revision = new AtomicLong(0L);
    private AtomicLong nbElems = new AtomicLong(0L);
    private long rootPageOffset;
    private long nextBTreeOffset;
    private int pageSize;
    private String name;
    private String keySerializerFQCN;
    private String valueSerializerFQCN;
    private long btreeOffset;
    private long[] versions;
    private int allowDuplicates = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long[] getVersions() {
        return this.versions;
    }

    void setVersions(long[] versions) {
        this.versions = versions;
    }

    long getBTreeOffset() {
        return this.btreeOffset;
    }

    void setBTreeOffset(long btreeOffset) {
        this.btreeOffset = btreeOffset;
    }

    long getRootPageOffset() {
        return this.rootPageOffset;
    }

    void setRootPageOffset(long rootPageOffset) {
        this.rootPageOffset = rootPageOffset;
    }

    public long getRevision() {
        return this.revision.get();
    }

    void setRevision(long revision) {
        this.revision.set(revision);
    }

    long incrementRevision() {
        return this.revision.incrementAndGet();
    }

    public long getNbElems() {
        return this.nbElems.get();
    }

    void incrementNbElems() {
        this.nbElems.incrementAndGet();
    }

    void decrementNbElems() {
        this.nbElems.decrementAndGet();
    }

    public void setNbElems(long nbElems) {
        this.nbElems.set(nbElems);
    }

    long getNextBTreeOffset() {
        return this.nextBTreeOffset;
    }

    void setNextBTreeOffset(long nextBTreeOffset) {
        this.nextBTreeOffset = nextBTreeOffset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    String getKeySerializerFQCN() {
        return this.keySerializerFQCN;
    }

    void setKeySerializerFQCN(String keySerializerFQCN) {
        this.keySerializerFQCN = keySerializerFQCN;
    }

    String getValueSerializerFQCN() {
        return this.valueSerializerFQCN;
    }

    void setValueSerializerFQCN(String valueSerializerFQCN) {
        this.valueSerializerFQCN = valueSerializerFQCN;
    }

    boolean isAllowDuplicates() {
        return this.allowDuplicates == 1;
    }

    void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates ? 1 : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Btree '").append(this.name).append("'");
        sb.append(", revision[").append(this.revision).append("]");
        sb.append(", btreeOffset[").append(this.btreeOffset).append("]");
        sb.append(", rootPageOffset[").append(this.rootPageOffset).append("]");
        sb.append(", nextBTree[").append(this.nextBTreeOffset).append("]");
        sb.append(", nbElems[").append(this.nbElems).append("]");
        sb.append(", pageSize[").append(this.pageSize).append("]");
        sb.append(", hasDuplicates[").append(this.isAllowDuplicates()).append("]");
        sb.append("{\n");
        sb.append("    Key serializer   : ").append(this.keySerializerFQCN).append("\n");
        sb.append("    Value serializer : ").append(this.valueSerializerFQCN).append("\n");
        sb.append("}\n");
        if (this.versions != null && this.versions.length != 0) {
            sb.append("Versions : \n");
            sb.append("{\n");
            boolean isFirst = true;
            for (long version : this.versions) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("    ").append(version);
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

