/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionSizeCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";
    private static final long MEGABYTE = 0x100000L;

    public RegionSizeCalculator(RegionLocator regionLocator, Admin admin) throws IOException {
        this.init(regionLocator, admin);
    }

    private void init(RegionLocator regionLocator, Admin admin) throws IOException {
        if (!this.enabled(admin.getConfiguration())) {
            LOG.info("Region size calculation disabled.");
            return;
        }
        if (regionLocator.getName().isSystemTable()) {
            LOG.info("Region size calculation disabled for system tables.");
            return;
        }
        LOG.info("Calculating region sizes for table \"" + regionLocator.getName() + "\".");
        Set<ServerName> tableServers = this.getRegionServersOfTable(regionLocator);
        for (ServerName tableServerName : tableServers) {
            for (RegionMetrics regionLoad : admin.getRegionMetrics(tableServerName, regionLocator.getName())) {
                byte[] regionId = regionLoad.getRegionName();
                long regionSizeBytes = (long)(regionLoad.getStoreFileSize().get(Size.Unit.MEGABYTE) + regionLoad.getMemStoreSize().get(Size.Unit.MEGABYTE)) * 0x100000L;
                this.sizeMap.put(regionId, regionSizeBytes);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Region " + regionLoad.getNameAsString() + " has size " + regionSizeBytes);
            }
        }
        LOG.debug("Region sizes calculated");
    }

    private Set<ServerName> getRegionServersOfTable(RegionLocator regionLocator) throws IOException {
        return regionLocator.getAllRegionLocations().stream().map(HRegionLocation::getServerName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            LOG.debug("Unknown region:" + Arrays.toString(regionId));
            return 0L;
        }
        return size;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }
}

