/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DescriptionUtils;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;

public class DitContentRule
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    private List<String> auxObjectClassOids;
    private List<ObjectClass> auxObjectClasses;
    private List<String> mayAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mayAttributeTypes;
    private List<String> mustAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> mustAttributeTypes;
    private List<String> notAttributeTypeOids = new ArrayList<String>();
    private List<AttributeType> notAttributeTypes;

    public DitContentRule(String oid) {
        super(SchemaObjectType.DIT_CONTENT_RULE, oid);
        this.auxObjectClassOids = new ArrayList<String>();
        this.mayAttributeTypes = new ArrayList<AttributeType>();
        this.mustAttributeTypes = new ArrayList<AttributeType>();
        this.notAttributeTypes = new ArrayList<AttributeType>();
        this.auxObjectClasses = new ArrayList<ObjectClass>();
    }

    public List<String> getAuxObjectClassOids() {
        return this.auxObjectClassOids;
    }

    public void addAuxObjectClassOidOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.auxObjectClassOids.add(oid);
        }
    }

    public void addAuxObjectClasses(ObjectClass objectClass) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly && !this.auxObjectClassOids.contains(objectClass.getOid())) {
            this.auxObjectClasses.add(objectClass);
            this.auxObjectClassOids.add(objectClass.getOid());
        }
    }

    public void setAuxObjectClassOids(List<String> auxObjectClassOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.auxObjectClassOids = auxObjectClassOids;
        }
    }

    public void setAuxObjectClasses(List<ObjectClass> auxObjectClasses) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.auxObjectClasses = auxObjectClasses;
            this.auxObjectClassOids.clear();
            for (ObjectClass oc : auxObjectClasses) {
                this.auxObjectClassOids.add(oc.getOid());
            }
        }
    }

    public List<ObjectClass> getAuxObjectClasses() {
        return this.auxObjectClasses;
    }

    public List<String> getMayAttributeTypeOids() {
        return this.mayAttributeTypeOids;
    }

    public void addMayAttributeTypeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypeOids.add(oid);
        }
    }

    public void addMayAttributeTypes(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly && !this.mayAttributeTypeOids.contains(attributeType.getOid())) {
            this.mayAttributeTypes.add(attributeType);
            this.mayAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public void setMayAttributeTypeOids(List<String> mayAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypeOids = mayAttributeTypeOids;
        }
    }

    public void setMayAttributeTypes(List<AttributeType> mayAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mayAttributeTypes = mayAttributeTypes;
            this.mayAttributeTypeOids.clear();
            for (AttributeType may : mayAttributeTypes) {
                this.mayAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public List<AttributeType> getMayAttributeTypes() {
        return this.mayAttributeTypes;
    }

    public List<String> getMustAttributeTypeOids() {
        return this.mustAttributeTypeOids;
    }

    public void addMustAttributeTypeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypeOids.add(oid);
        }
    }

    public void addMustAttributeTypes(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly && !this.mustAttributeTypeOids.contains(attributeType.getOid())) {
            this.mustAttributeTypes.add(attributeType);
            this.mustAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public void setMustAttributeTypeOids(List<String> mustAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypeOids = mustAttributeTypeOids;
        }
    }

    public void setMustAttributeTypes(List<AttributeType> mustAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.mustAttributeTypes = mustAttributeTypes;
            this.mustAttributeTypeOids.clear();
            for (AttributeType may : mustAttributeTypes) {
                this.mustAttributeTypeOids.add(may.getOid());
            }
        }
    }

    public List<AttributeType> getMustAttributeTypes() {
        return this.mustAttributeTypes;
    }

    public List<String> getNotAttributeTypeOids() {
        return this.notAttributeTypeOids;
    }

    public void addNotAttributeTypeOids(String oid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.notAttributeTypeOids.add(oid);
        }
    }

    public void addNotAttributeTypes(AttributeType attributeType) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly && !this.notAttributeTypeOids.contains(attributeType.getOid())) {
            this.notAttributeTypes.add(attributeType);
            this.notAttributeTypeOids.add(attributeType.getOid());
        }
    }

    public void setNotAttributeTypeOids(List<String> notAttributeTypeOids) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.notAttributeTypeOids = notAttributeTypeOids;
        }
    }

    public void setNotAttributeTypes(List<AttributeType> notAttributeTypes) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.notAttributeTypes = notAttributeTypes;
            this.notAttributeTypeOids.clear();
            for (AttributeType not : notAttributeTypes) {
                this.notAttributeTypeOids.add(not.getOid());
            }
        }
    }

    public List<AttributeType> getNotAttributeTypes() {
        return this.notAttributeTypes;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public DitContentRule copy() {
        DitContentRule copy = new DitContentRule(this.oid);
        copy.copy(this);
        copy.auxObjectClassOids = new ArrayList<String>();
        for (String oid : this.auxObjectClassOids) {
            copy.auxObjectClassOids.add(oid);
        }
        copy.auxObjectClasses = new ArrayList<ObjectClass>();
        copy.mayAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mayAttributeTypeOids) {
            copy.mayAttributeTypeOids.add(oid);
        }
        copy.mayAttributeTypes = new ArrayList<AttributeType>();
        copy.mustAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.mustAttributeTypeOids) {
            copy.mustAttributeTypeOids.add(oid);
        }
        copy.mustAttributeTypes = new ArrayList<AttributeType>();
        copy.notAttributeTypeOids = new ArrayList<String>();
        for (String oid : this.notAttributeTypeOids) {
            copy.notAttributeTypeOids.add(oid);
        }
        copy.notAttributeTypes = new ArrayList<AttributeType>();
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof DitContentRule)) {
            return false;
        }
        DitContentRule that = (DitContentRule)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.auxObjectClasses.clear();
        this.auxObjectClassOids.clear();
        this.mayAttributeTypes.clear();
        this.mayAttributeTypeOids.clear();
        this.mustAttributeTypes.clear();
        this.mustAttributeTypeOids.clear();
        this.notAttributeTypes.clear();
        this.notAttributeTypeOids.clear();
    }
}

